function dark_scale,superdark,refdark,short=short

; scale dark image according to inimage count.

  common gui,logger
  
  s=size(refdark) & if s[0] EQ 3 then n_subframe=s[3] else n_subframe=1
  scaled_dark=fltarr(size(refdark,/dimensions))
  
  if keyword_set(short) && defined(logger) then $
    logger->append,['  Dark offset (short) (ADU):'] $
  else $
    logger->append,['  Dark offset (long) (ADU):']

  if keyword_set(short) then begin
; for short
     irc_mmm,superdark[!IRC_SPECRED_AREAINFO.slitmask_x1: !IRC_SPECRED_AREAINFO.slitmask_x2, $
                       !IRC_SPECRED_AREAINFO.slitmask_y1: !IRC_SPECRED_AREAINFO.slitmask_y2,0], $
             dark_mean ,sigma,skew
     irc_mmm,superdark[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                       !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2,0], $
             dark_mean2,sigma,skew
     irc_mmm,refdark[!IRC_SPECRED_AREAINFO.slitmask_x1:!IRC_SPECRED_AREAINFO.slitmask_x2, $
                     !IRC_SPECRED_AREAINFO.slitmask_y1:!IRC_SPECRED_AREAINFO.slitmask_y2, 0],$
             refdark_dark_mean ,sigma,skew
     irc_mmm,refdark[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                     !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2,0], $
             refdark_dark_mean2,sigma,skew
     refdark_mean_mean=(refdark_dark_mean+refdark_dark_mean2)/2.
     dark_mean_mean=(dark_mean+dark_mean2)/2.
;    dark_offset=((refdark_dark_mean-dark_mean)+(refdark_dark_mean2-dark_mean2))/2.
     dark_offset=refdark_mean_mean-dark_mean_mean
     print,'Information (irc_darksub): average of superdark and predark (short): ',dark_mean_mean,refdark_mean_mean
     d_dark_frac=dark_offset/refdark_mean_mean*100.
     if defined(logger) then logger->append,['    Subframe id'+string(0)+': '+string(dark_offset)]
     scaled_dark[*,*,0]=superdark[*,*,0]+dark_offset
  endif else begin
; for long
     irc_mmm,superdark[!IRC_SPECRED_AREAINFO.slitmask_x1: !IRC_SPECRED_AREAINFO.slitmask_x2, $
                       !IRC_SPECRED_AREAINFO.slitmask_y1: !IRC_SPECRED_AREAINFO.slitmask_y2,1],$
             dark_mean ,sigma,skew
     irc_mmm,superdark[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                       !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2,1], $
             dark_mean2,sigma,skew
     
     for i=0,n_subframe-1 do begin ; was fom i=1
        irc_mmm,refdark[!IRC_SPECRED_AREAINFO.slitmask_x1:!IRC_SPECRED_AREAINFO.slitmask_x2, $
                        !IRC_SPECRED_AREAINFO.slitmask_y1:!IRC_SPECRED_AREAINFO.slitmask_y2, i], $
                refdark_dark_mean ,sigma,skew
        irc_mmm,refdark[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                        !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2,i], $
                refdark_dark_mean2,sigma,skew
        
        refdark_mean_mean=(refdark_dark_mean+refdark_dark_mean2)/2.
        dark_mean_mean=(dark_mean+dark_mean2)/2.
;       dark_offset=((refdark_dark_mean-dark_mean)+(refdark_dark_mean2-dark_mean2))/2.
        dark_offset=refdark_mean_mean-dark_mean_mean
        print,'Information (irc_darksub): average of superdark and predark (long): ',dark_mean_mean,refdark_mean_mean

        d_dark_frac=dark_offset/refdark_mean_mean*100.
;  print,(dark_mean+dark_mean2)/2.,(refdark_dark_mean+refdark_dark_mean2)/2.
        if defined(logger) then logger->append,['    Subframe id'+string(i)+': '+string(dark_offset)]
;  print,'dark offset '+string(dark_offset)
        scaled_dark[*,*,i]=superdark[*,*,i+1]+dark_offset
     endfor
  endelse
  
  return,scaled_dark
  
end

PRO irc_darksub,inimage,superdark,refdark,outimage, $
                scale_dark=scale_dark,short=short,scaled_dark=scaled_dark

  s=size(inimage) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1
  outimage=fltarr(size(inimage,/dimensions))

;  if keyword_set(scale) then scaled_dark=dark_scale(superdark,refdark[*,*,*,0],short=short) else $
;                             scaled_dark=superdark
                                ; refdark[*,*,*,0] means pre-dark.
  
  if ~ defined(scaled_dark) then begin
      if keyword_set(scale_dark) then scaled_dark=dark_scale(superdark,refdark,short=short) else begin
          if keyword_set(short) then scaled_dark=superdark[*,*,0] else scaled_dark=superdark[*,*,1:3]
      endelse
  endif

  sub_frame_id=0
  for frame_id=0,n_frame-1 do begin
;     if !IRC_SPECRED_OBSPARAM.slit_mode EQ 0B then begin
        outimage[*,*,frame_id]=inimage[*,*,frame_id]-scaled_dark[*,*,sub_frame_id]
        sub_frame_id+=1
        if keyword_set(short) || NIR() then sub_frame_id=0 else begin
           if sub_frame_id EQ 3 then sub_frame_id=0
        endelse
;     endif else begin
;        outimage[*,*,frame_id]=inimage[*,*,frame_id]
;     endelse
; do self dark sub
     if NIR() || MIRS() then begin
        irc_mmm,outimage[!IRC_SPECRED_AREAINFO.slitmask2_x1:!IRC_SPECRED_AREAINFO.slitmask2_x2, $
                         !IRC_SPECRED_AREAINFO.slitmask2_y1:!IRC_SPECRED_AREAINFO.slitmask2_y2, frame_id], $
                self_dark_mean,sigma,skew
; upper-left most sub-region
        outimage[*,*,frame_id]-=self_dark_mean
     endif
  endfor

END
