pro ds9_make_fits_files_single,specimage3d

  s=size(specimage3d) & if s[0] EQ 2 then n_source=1 else n_source=s[3]
  
  for i=0,n_source-1 do begin
     if n_source GT 1 then begin ; the case of 3D image
        specimage3d_slice=specimage3d[*,*,i]
     endif else begin           ; the case of 2D
        specimage3d_slice=specimage3d[*,*]
     endelse
     
     filename=strcompress(!IRC_SPECRED_DIR.tmpdir+'/tmp.'+string(i)+'.fits',/remove_all)
     file_delete,filename,/allow_nonexistent
     mwrfits,specimage3d_slice,filename,/silent
  endfor
end

pro irc_edit_frames_on_ds9,specimage3d,use_array,edit_anyway=edit_anyway,zoom=zoom,mask_no_use=mask_no_use

; do nothing because it is auto mode.
  if  ~ keyword_set(edit_anyway) && $
     (!IRC_SPECRED_PROCESSOPTION.non_interactive_mode EQ 1B || $
     !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 1B) then return

  s=size(specimage3d) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1
  if defined(use_array) && ~ keyword_set(edit_anyway) then goto,apply_mask else use_array=indgen(n_frame)+1

  dx=(s[1]-1)/2 & dy=(s[2]-1)/2

  case 1 of
  (NIR()) : begin xgrid=1 & ygrid=9 & end
  (MIRS()): begin xgrid=3 & ygrid=5 & end
  (MIRL()): begin xgrid=3 & ygrid=9 & end
  endcase

  set_ds9_title,'IRC_SPECRED_FRAME_SELECT',ds9_title
  
  ds9_init,n_frame,xgrid=xgrid,ygrid=ygrid,title=ds9_title

  if defined(zoom) then fac=float(zoom) else begin
     if NIR() then fac=1 else fac=1; 2
  endelse

  spawn,'xpaset -p '+ds9_title+' width '+strcompress(string(fix(s[1]*fac*xgrid)),/remove)
  if defined(zoom) then begin
     spawn,'xpaset -p '+ds9_title+' zoom '+strcompress(string(fix(zoom)),/remove)
  endif

  ds9_make_fits_files_single,specimage3d
  ds9_fits_file_read,n_frame,title=ds9_title
  result=dialog_message('Press here after editing on DS9',/information)
  ds9_activeframe_read,use_array,title=ds9_title
  use_array-=1                  ; subtract one for IDL frame_id

apply_mask:

; apply mask
  for i=0,n_frame-1 do begin
     result=where(use_array EQ i,count)
     if count EQ 0 then specimage3d[*,*,i]=!values.f_nan
  endfor

  if keyword_set(mask_no_use) then begin
     for frame_id=0,n_frame-1 do begin
        use=where(use_array EQ frame_id,count)
        if count EQ 0 then begin
           specimage3d[*,*,frame_id]=!values.f_nan
           print,'masked',frame_id
        endif
     endfor
  endif

end
