pro set_flatcor,flat

; common frame_type,chip,filter,grism
;  common dir_structure,datadir,calibdir
  
  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin
        case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin
              filename=!IRC_SPECRED_DIR.calibdir+'FLAT/SPEC2DFLATCOR_NP.lst'
           end
           1: begin
              filename=!IRC_SPECRED_DIR.calibdir+'FLAT/SPEC2DFLATCOR_NP.lst'
           end
        endcase
     end
     1: begin
        case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin
              filename=!IRC_SPECRED_DIR.calibdir+'FLAT/SPEC2DFLATCOR_SG1.lst'
           end
           1: begin
              filename=!IRC_SPECRED_DIR.calibdir+'FLAT/SPEC2DFLATCOR_SG2.lst'
           end
        endcase
     end
     2: begin
        case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin
              filename=!IRC_SPECRED_DIR.calibdir+'FLAT/SPEC2DFLATCOR_LG1.lst'
           end
           1: begin
              filename=!IRC_SPECRED_DIR.calibdir+'FLAT/SPEC2DFLATCOR_LG2.lst'
           end
        endcase
     end
  endcase
  
  irc_list_fits_read,filename,flat_nir,flat_mirs,flat_mirl, $
                     n_nir,n_mir,flatheader_nir,flatheader_mirs,flatheader_mirl,dir=!IRC_SPECRED_DIR.calibdir+'FLAT/',/SEPARATE
  
  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin
        flat_tmp=flat_nir
        rot_image3d,flat_tmp,flat
     end
     1: begin
        flat=flat_mirs
     end
     2: begin
        flat=flat_mirl
     end
  endcase
  
end

pro calc_flatcor,flatcor,source_table,flatcor_n

;common frame_type,chip,filter,grism

n_source=n_elements(source_table)
flatcor_n=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,n_source)
get_chip_dims,ncol,nrow

for source_id=0,n_source-1 do begin
   for y=0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1 do begin
      for x=0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1 do begin
         xorg=get_xorg(source_table,source_id,x) < (ncol-1) > 0
         yorg=get_yorg(source_table,source_id,y) < (nrow-1) > 0
         flatcor_n[x,y,source_id]=flatcor[xorg,yorg]
      endfor
   endfor
endfor                          ; of source_id

end

pro irc_flatcor,specimage_n_sff,source_table,specimage_n_sff2

set_flatcor,flatcor
calc_flatcor,flatcor,source_table,flatcor_n
specimage_n_sff2=specimage_n_sff*flatcor_n; not deviding, but multiplexing!

end
