pro irc_skysub_adopt,image,mask,image_bg,sigma,dx=dx,dy=dy

  nan=where(finite(image),count)
  if count EQ 0 then return

  if defined(dx) then width_x=dx else width_x=!IRC_SPECRED_SKYFITORDER.sky_fit_dx ; was 20
  if defined(dy) then width_y=dy else width_y=!IRC_SPECRED_SKYFITORDER.sky_fit_dy ; was 3

  clip_factor=3.0               ; was 1.5

  max_repeat=30
  edge_width=0                  ; was fix(width_x/2)
  s=size(image) & xsize=s[1] & ysize=s[2]
  
; mask out regions where pixel count is too much.
  image_objmask=image
  image_med=filter_image(image,median=4) ; preset values
  sky_rms=robust_sigma_mod(image*mask)
  sky_value=median(image*mask)
; print,'rms (with/without mask)',robust_sigma(image*mask),robust_sigma(image)
; objmask=where(image_med GT sky_value+clip_factor*sky_rms,count_objmask)
  objmask=where(image GT sky_value+clip_factor*sky_rms OR $
                image LT sky_value-clip_factor*sky_rms, $
                count_objmask)
  if count_objmask GT 0 then image_objmask[objmask]=!values.f_nan
; print,count_objmask

  mask_grow,image_objmask,image_objmask_grow,grow_width=1

  image_expand=make_array(xsize+2*edge_width,ysize+2*edge_width,/float,value=!values.f_nan)
  image_expand[edge_width:xsize+edge_width-1,edge_width:ysize+edge_width-1]=image_objmask_grow
  
  mask_expand=make_array(xsize+2*edge_width,ysize+2*edge_width,/float,value=!values.f_nan)
  mask_expand[edge_width:xsize+edge_width-1,edge_width:ysize+edge_width-1]=mask
  
  sky_image=filter_image(image_expand,median=width_x) ; preset values
  
  dx0=fix(width_x/2) & dy0=fix(width_y/2) & repeat_count=0
  dx1=dx0 & dy1=dy0
  if MIRS() then x_offset=22 else x_offset=0 ; to exclude slit-masked area for speeding up the calculation...

  for x=edge_width+x_offset,xsize+2*edge_width-1 do begin
     for y=edge_width,ysize+2*edge_width-1 do begin
;       if finite(image_med[x,y]) then continue
        expand_medsize:
        image_cut=image_expand[x-dx1>0:x+dx1<xsize+2*edge_width-1,y-dy1>0:y+dy1<ysize+2*edge_width-1] $
                 * mask_expand[x-dx1>0:x+dx1<xsize+2*edge_width-1,y-dy1>0:y+dy1<ysize+2*edge_width-1]
        nonnan=where(finite(image_cut),count)
;       if count GT (1*dx1+1)*(1*dy1+1)*0.5 || repeat_count GT max_repeat then begin
        if count GT 16 || repeat_count GT max_repeat then begin
              
; Simple median method
           sky_image[x,y]=median(image_cut)
           
; Simple mean_clip method
;          meanclip_mod,image_cut,tmp,sigma,clipsig=2.
;          sky_image[x,y]=tmp
           
; Heavy loess method
;          s=size(image_cut) & loess_width=min([s[1], s[2]])
;          image_cut2=image_cut
;          nan=where(finite(image_cut,/NAN),count2)
;          if count2 GT 0 then image_cut2[nan]=-9999
;          image_cut3=loess_mod(image_cut2,loess_width,1,floor=-9998)
;          sky_image[x,y]=image_cut3[fix(s[1]/2)+1,fix(s[2]/2)+1]
           
           repeat_count=0
           dx1=dx0
           dy1=dy0
        endif else begin
           dx1+=2
           dy1+=2
           repeat_count+=1
;          print,'repeating',repeat_count,dx1,dy1
           goto,expand_medsize
        endelse
     endfor
  endfor

  sky_image=sky_image[edge_width:xsize+edge_width-1,edge_width:ysize+edge_width-1]

;  endif else $
;     sky_image=meanclip_smooth(image*mask,width_x,width_y,clip_sig=1.5) ; actual median width = 2x+1 vs. 2y+1
;;    sky_image=loess_mod_xy(image,width_x,width_y,1,floor=-100.) ; width_x and _y should be in odd number


;  image_bg=image-sky_image
  image_bg=image-filter_image_nan(sky_image,smooth=width_y)

  sigma=robust_sigma_mod(image_bg)
  
end
