PRO irc_skysub_indivframe,inimage,outimage, $
                          weight=weight,short=short,mask=mask,source_table=source_table,objmask=objmask, $
                          dx=dx,dy=dy,outmask=outmask,imag=imag

  common GUI,logger

  s=size(inimage) & ncol=s[1] & nrow=s[2] & if s[0] EQ 3 then n_frame=s[3] else n_frame=1

; since in the first pass there is no mask available, expand the mask
; area for better masking

  if ~ defined(mask) then begin
     mask2=make_array(ncol,nrow,/float,value=1.) ; dummy mask (not masked at all!)
     expand_fac=2.0
  endif else begin
     mask2=mask
     expand_fac=1.0
  endelse

  outimage=fltarr(ncol,nrow,n_frame)
  weight=fltarr(n_frame)

  if defined(logger) then logger->append,['  skysub residual RMS (ADU):']

; mask preparation  
  if defined(source_table) then begin
     if ~ defined(imag) then begin
        make_wholemask,source_table.spec_x,source_table.spec_y, $
                       fix(source_table.spec_mask_dx),fix(source_table.spec_mask_dy),mask3_main, $
                       objmask=objmask ;,/show_mask
        make_wholemask,source_table.spec_x,source_table.spec_y, $
                       fix(source_table.spec_mask_dx),fix(source_table.spec_mask_dy),mask3_sub, $
                       /narrow_mask
        mask3=mask3_main*mask3_sub

        if defined(objmask) then mask4=mask3 else mask4=mask2*mask3
     endif else begin
        make_wholemask,source_table.spec_x,source_table.spec_y, $
                       fix(source_table.spec_mask_dx),fix(source_table.spec_mask_dy),mask3, $
                       objmask=objmask,/circular ;,/show_mask
        mask4=mask3
     endelse
  endif else begin              ; in case of no source_table
     mask4=mask2
  endelse

; do actual skysub

  case 1 of
     (NP() || NG() ): begin
        for i=0,n_frame-1 do begin
           if defined(source_table) then begin ;with source table
              if ~ defined(dx) then begin
                 dx=fltarr(n_frame)
                 dy=fltarr(n_frame)
              endif
              
              n_dx=n_elements(dx) & n_dy=n_elements(dy)
             
              if n_dx GT i-1 then dx=[dx,dx[n_dx-1]]
              if n_dy GT i-1 then dy=[dy,dy[n_dy-1]]

              irc_skysub_fit,inimage[*,*,i],shift(mask4,dx[i],dy[i]),tmp,sigma, $
                             fitorder=sky_fit_indiv_order,short=short
           endif else begin
              irc_skysub_fit,inimage[*,*,i],mask4,tmp,sigma, $
                             fitorder=sky_fit_indiv_order,short=short
           endelse
           outimage[*,*,i]=tmp
           weight[i]=1./sigma^2.
           if defined(logger) then logger->append,['    Subframe id'+string(i)+': '+string(sigma)]
        endfor
     end
     
     (SG1() || SG2() || LG2()): begin
        if LG2() then mask_fac=1.5 else mask_fac=2.0

        for i=0,n_frame-1 do begin
           if ~ keyword_set(short) then begin ; for long
              if defined(source_table) then begin ;with source table

; extend array in case of inconsistency
                 if ~ defined(dx) then begin
                    dx=fltarr(n_frame)
                    dy=fltarr(n_frame)
                 endif
                 
                 n_dx=n_elements(dx) & n_dy=n_elements(dy)
                 
                 if n_dx GT i-1 then dx=[dx,dx[n_dx-1]]
                 if n_dy GT i-1 then dy=[dy,dy[n_dy-1]]

                 irc_skysub_fit,inimage[*,*,i],shift(mask4,dx[i],dy[i]),tmp,sigma, $
                                fitorder=1,short=short
                 irc_skysub_adopt,tmp,shift(mask4,dx[i],dy[i]),tmp,sigma, $
;                irc_skysub_adopt,inimage[*,*,i],shift(mask4,dx[i],dy[i]),tmp,sigma, $
                                  dx=!IRC_SPECRED_SKYFITORDER.sky_fit_dx, $
                                  dy=!IRC_SPECRED_SKYFITORDER.sky_fit_dy*mask_fac
                                ; should be odd number for loess
              endif else begin  ;without source table
;                 irc_skysub_fit,inimage[*,*,i],mask4,tmp,sigma, $
;                                fitorder=1,short=short
;                 irc_skysub_adopt,tmp,mask4,tmp,sigma, $
                 irc_skysub_adopt,inimage[*,*,i],mask4,tmp,sigma, $
                                  dx=!IRC_SPECRED_SKYFITORDER.sky_fit_dx*expand_fac, $
                                  dy=!IRC_SPECRED_SKYFITORDER.sky_fit_dy*mask_fac
                                ; should be odd number for loess
              endelse
            
              outimage[*,*,i]=tmp
              weight[i]=1./sigma^2.
              if defined(logger) then logger->append,['    Subframe id'+string(i)+': '+string(sigma)]
           endif else begin     ; for short
              irc_skysub_fit,inimage[*,*,i],mask2,tmp,sigma, $
                             fitorder=sky_fit_indiv_order,short=short
              outimage[*,*,i]=tmp
              weight[i]=1./sigma^2.
              if defined(logger) then logger->append,['    Subframe id'+string(i)+': '+string(sigma)]
           endelse
        endfor
     end
  endcase

  if defined(mask4) then outmask=mask4

END
