pro irc_skysub_mean,specimage,mask_specimage,x1,x2,y1,y2,skymod,sigma_value,weightmap=weightmap

; calc sky value with mask. Sky is assumed constant across the image.

  n_sigma=1.5                   ; was 3.0

  s=size(mask_specimage) & xsize=s[1] & ysize=s[2]

  mask_specimage_min=mask_specimage[x1:x2,y1:y2]
  specimage_min=specimage[x1:x2,y1:y2]
  weightmap_min=weightmap[x1:x2,y1:y2]

  robust_sky_rms=robust_sigma_mod(mask_specimage_min*specimage_min)
  robust_sky_mean=median(mask_specimage_min*specimage_min)

  not_masked=where( $
             finite(mask_specimage_min) AND $
             (specimage_min NE 0 OR finite(specimage_min)) AND $
             (specimage_min GT robust_sky_mean-3.*robust_sky_rms AND specimage_min LT robust_sky_mean+3.*robust_sky_rms), $
             n_skypix)

  masked=where( $
         finite(mask_specimage_min,/NAN) OR $
         (specimage_min EQ 0 OR finite(specimage_min,/NAN)) OR $
         (specimage_min LT robust_sky_mean-n_sigma*robust_sky_rms OR specimage_min GT robust_sky_mean+n_sigma*robust_sky_rms), $
         n_skypix_tmp)

  specimage_min_masked=specimage_min
  if n_skypix_tmp GT 0 then specimage_min_masked[masked]=!values.f_nan
; atv,specimage_min_masked,/b
  
  if n_skypix LT 50 then begin
     skymod=0.
     sigma_value=0.
;    print,'Warning (irc_skysub_mean): Available sky area is too small! (due to mask or out-of-fov) '+strim(n_skypix)+' (pix)'
  endif else begin
;    irc_mmm,specimage_min[tmp],skymod0,sigma_value,skew
     meanclip_mod,specimage_min[not_masked],skymod,sigma_value,clipsig=3.,weight=weightmap_min[not_masked]
;    skymod2=median(specimage_min[tmp])
;    print,skymod0,skymod,skymod2
;    sigma_value=robust_sigma_mod(specimage_min[tmp])
  endelse
  
  if sigma_value LT 0. then begin
     skymod=median(specimage_min[masked])
     sigma_value=-1.
  endif

  skymod=float(skymod)
  if ~ finite(skymod) then skymod=0.
  sigma_value=float(sigma_value)

end
