Pro irc_specred,targetid,targetsubid,ext_source_table,refimage_list,specimage_list,filter_spec, $
                Root_dir=root_dir, $
                Ns_spec=Ns_spec,Nh_spec=Nh_spec,Np_spec=Np_spec,Ls_spec=Ls_spec, $
                brightest_10_source=brightest_10_source, $
                no_tune_sourcepos=no_tune_sourcepos, $
                use_short_refimage=use_short_refimage, $
                interactive_skyset=interactive_skyset, $
                ds9_edit=ds9_edit,no_show_ds9=no_show_ds9, $
                streak_cor=streak_cor, $
                rotated_NIR_source_table=rotated_NIR_source_table, $
                source_table_offset_x_value=source_table_offset_x_value, $
                source_table_offset_y_value=source_table_offset_y_value, $
                preflight_data=preflight_data,NP_linear=NP_linear,no_NP_distortion=no_NP_distortion,debug=debug, $
                auto_image_stack=auto_image_stack,no_slit_flat=no_slit_flat,no_database_check=no_database_check, $
                no_fov_mask=no_fov_mask,non_interactive=non_interactive,simple_skysub=simple_skysub, $
                use_all_images=use_all_images, $
                no_message_finish=no_message_finish,message_finish=message_finish, $
                faint_source=faint_source,point_remover=point_remover, $
                nir_column_pulldown_correction=nir_column_pulldown_correction, $
                mir_column_pulldown_correction=mir_column_pulldown_correction, $
                fine_darksub_at_Np=fine_darksub_at_Np,putwcs=putwcs, $
                use_external_shiftfile_for_NIR=use_external_shiftfile_for_NIR, $
                make_4d_output=make_4d_output,savefile=savefile,no_soramame=no_soramame,objmask_file=objmask_file, $
                edit_frame_before_skysub=edit_frame_before_skysub, $
                mir_fileshift=mir_fileshift

; parameter check
  if N_params() NE 6 then message,'Error (irc_specred): Wrong number of arguments!'
  
; Definitions of common blocks
  common gui,logger
  
; Initialization
  init_specred,targetid,targetsubid,ext_source_table,refimage_list,specimage_list,filter_spec, $
               Root_dir=root_dir, $
               Ns_spec=Ns_spec,Nh_spec=Nh_spec,Np_spec=Np_spec,Ls_spec=Ls_spec, $
               brightest_10_source=brightest_10_source, $
               no_tune_sourcepos=no_tune_sourcepos, $
               use_short_refimage=use_short_refimage, $
               interactive_skyset=interactive_skyset, $
               ds9_edit=ds9_edit, $
               rotated_NIR_source_table=rotated_NIR_source_table, $
               preflight_data=preflight_data,NP_linear=NP_linear,no_NP_distortion=no_NP_distortion,debug=debug, $
               auto_image_stack=auto_image_stack,no_slit_flat=no_slit_flat,no_database_check=no_database_check, $
               no_fov_mask=no_fov_mask,non_interactive=non_interactive,simple_skysub=simple_skysub, $
               use_all_images=use_all_images,faint_source=faint_source,point_remover=point_remover, $
               nir_column_pulldown_correction=nir_column_pulldown_correction, $
               mir_column_pulldown_correction=mir_column_pulldown_correction, $
               streak_cor=streak_cor,fine_darksub_at_Np=fine_darksub_at_Np,putwcs=putwcs,no_soramame=no_soramame, $
               mir_fileshift=mir_fileshift


  if !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 1B then begin
     catch,error_status
     if error_status NE 0 then begin
        print,'Error was detected! Exiting...'
        exit,status=error_status
     endif
  endif
                 
; Data processing begins here.

  do_load_images,ext_source_table,refimage_list,specimage_list,darkimage_list, $
                 refimage,refimage_short,specimage,specimage_short, $
                 imagheader,specheader, $
                 superdark,imageflat,specflat,flatcor,refdark_long,refdark_short, $
                 soramame_flag=soramame_flag,no_database_check=no_database_check

  do_darksub,refimage,refimage_short,specimage,specimage_short,superdark,refdark_long,refdark_short, $
             refimage_ds,refimage_ds_short,specimage_ds,specimage_ds_short,hotpix=hotpix;, $
;            superdark_combined=superdark_combined,refdark_combined=refdark_combined,hotpix_image=hotpix_image

  do_linear_cor,refimage_ds,refimage_ds_short,specimage_ds,specimage_ds_short, $
                refimage_lc,refimage_lc_short,specimage_lc,specimage_lc_short

  do_flatcalib,refimage_lc,refimage_lc_short,specimage_lc,specimage_lc_short,imageflat,specflat, $
               refimage_ff,refimage_ff_short,specimage_ff,specimage_ff_short

  apply_outlier_saturation_mask,specimage_ff,specimage_ff_short,specimage_ff_mask,specimage_ff_short_mask,fov_mask=fov_mask
  apply_outlier_saturation_mask, refimage_ff, refimage_ff_short, refimage_ff_mask, refimage_ff_short_mask,/IMAG

  !IRC_SPECRED_MISC.first_pass=1B
  if keyword_set(use_external_shiftfile_for_NIR) then $
     read_shiftinfo_from_file=1B $
  else $
     read_shiftinfo_from_file=0B

  no_crrej=1B
  interactive=1B

  if defined(objmask_file) then objmask=mrdfits(objmask_file,0,objmaskheader,/silent)

;  help,edit_frame_before_skysub

  if keyword_set(edit_frame_before_skysub) then $
     irc_edit_frames_on_ds9,specimage_ff_mask,use_array_tmp,/mask_no_use,/edit_anyway

repeat_from_skysub_indiv:

  do_skysub_indivframe, $
     refimage_ff_mask,specimage_ff_mask,refimage_ss_mask,specimage_ss_mask, $
     refimage_ff_short_mask,specimage_ff_short_mask,refimage_ss_short_mask,specimage_ss_short_mask, $
     weight_spec_long=weight_spec_long,weight_ref_long=weight_ref_long, $
     weight_spec_short=weight_spec_short,weight_ref_short=weight_ref_short, $
     specmask=mask_specimage,imagmask=mask_refimage,source_table=source_table,objmask=objmask,dx=dx,dy=dy

; if !IRC_SPECRED_MISC.first_pass EQ 0 then message,'Finish'

  irc_edit_frames_on_ds9,specimage_ss_mask,use_array_from_ds9_edit

; added on July 2010 to count useful frame number.
  s=size(specimage_ss_mask) & if s[0] EQ 2 then n_frame=1 else n_frame_long=s[3]
  s=size(specimage_ss_short_mask) & if s[0] EQ 2 then n_frame=1 else n_frame_short=s[3]

  do_image_combine,refimage_ss_mask,refimage_ss_short_mask,refimage_ff, $
                   specimage_ss_mask,specimage_ss_short_mask,specimage_ff, $
                   weight_spec_long=weight_spec_long,weight_ref_long=weight_ref_long, $
                   weight_spec_short=weight_spec_short,weight_ref_short=weight_ref_short, $
                   noisemap=noisemap, $
                   specimage_ff_shift=specimage_ff_shift,specimage_ff_short_shift=specimage_ff_short_shift,inimage_shift_skyadj=inimage_shift_skyadj, $
                   no_crrej=no_crrej,read_shiftinfo_from_file=read_shiftinfo_from_file, $
                   dx_sl_imag=dx_sl_imag,dy_sl_imag=dy_sl_imag, $
                   dx_sl_spec=dx_sl_spec,dy_sl_spec=dy_sl_spec, $
                   dx_spec=dx,dy_spec=dy

  refimage_ff_cor=refimage_ff

  if !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 0B $
     && ~ keyword_set(no_show_ds9) $
     && ~ keyword_set(non_interactive) $
  then begin
     show_aperture_on_ds9,specimage_ff,source_table,space_shift=space_shift,nsum=nsum
     show_aperture_on_ds9,refimage_ff_cor,source_table,/IMAG,space_shift=space_shift,nsum=nsum
  endif
  
  if !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 1B then begin
     process_header,specheader,imagheader,source_table,specheader_extract,imagheader_extract
     
     logger->append,['---','All done (only for whole image stacking).']
     
     write_all_output,source_table,space_profile,spec_profile,wave_array,specimage_fc_1d, $
                      refimage_ff,specimage_ff, $
                      refimage_n_bg,refimage_n_bg_short, $
                      specimage_n_sff,specimage_n_sff_short, $
                      specimage_n_wc,specimage_n_wc_short, $
                      specimage_n_fc,specimage_n_fc_short, $
                      res_refimage_bg,res_specimage_bg, $
                      mask_refimage,mask_specimage,mask_specimage_n, $
                      imagheader,specheader,imagheader_extract,specheader_extract, $
                      noisemap,noisemap_n,noisemap_short_n,noise_mask, $
                      dir=!IRC_SPECRED_DIR.workdir,savefile=savefile
     exit, status=0             ; normal end
  end

; Target detection/sky subtraction/sub-aperture extraction
  irc_source_detect_extract2,refimage_ff_cor,specimage_ff,ext_source_table,source_table, $
                             refimage_bg,specimage_bg,refimage_n_bg,refimage_n_bg_short,specimage_n,specimage_n_short, $
                             res_refimage_bg,res_specimage_bg, $
                             mask_refimage,mask_specimage, $
                             source_table_offset_x_value=source_table_offset_x_value, $
                             source_table_offset_y_value=source_table_offset_y_value,fov_mask=fov_mask, $
                             noisemap_whole=noisemap, $
                             noisemap_n=noisemap_n,noisemap_short_n=noisemap_short_n, $
                             noise_mask=noise_mask, $
                             interactive=interactive,objmask=objmask


  if !IRC_SPECRED_MISC.first_pass then begin
     no_crrej=0B
     interactive=0B
     read_shiftinfo_from_file=1B
     !IRC_SPECRED_MISC.first_pass=0B
     goto,repeat_from_skysub_indiv
  endif
  
  if !IRC_SPECRED_OBSPARAM.slit_mode EQ 0B $
     && !IRC_SPECRED_OBSPARAM.AOT NE '02B' $
     && !IRC_SPECRED_PROCESSOPTION.streak_cor_mode EQ 1B $
  then begin
     specimage_bg_0=specimage_bg
     irc_streakcor,specimage_bg,res_specimage_bg,specimage_bg_streakcor
     specimage_bg=specimage_bg_streakcor
  endif
  
; do further skysub for each extracted spec image

; added n_frame on 2010 July
  do_skysub_n,source_table,specimage_n,specimage_n_short,mask_specimage_n, $
              specimage_n_bg,specimage_n_bg_short, $ ; was mask_specimage_n
              fov_mask=fov_mask, $
              noisemap_n=noisemap_n,noisemap_short_n=noisemap_short_n,noise_mask=noise_mask,objmask=objmask, $
              mmm=mmm,n_frame_long=n_frame_long,n_frame_short=n_frame_short

; Do lambda_dependent flat_fielding
  do_specflat,specimage_n_bg,specimage_n_bg_short,source_table,specimage_n_sff,specimage_n_sff_short
  
; Do wavelength calibration
  do_wavecalib,specimage_n_sff,specimage_n_sff_short,source_table,specimage_n_wc,specimage_n_wc_short,wave_array,use_array=use_array,specbox_y_shift=specbox_y_shift,d_wave_offset_pix=d_wave_offset_pix

; Do sensitivity correction
  irc_senscalib,specimage_n_wc,specimage_n_wc_short,mask_specimage_n,wave_array,source_table, $
                specimage_n_fc,specimage_n_fc_short,sigmaimage_n_fc,sigmaimage_n_fc_short, $
                noisemap_long=noisemap_n,noisemap_short=noisemap_short_n

  make_spec1d,specimage_n_wc,specimage_n_fc,mask_specimage_n,sigmaimage_n_fc,source_table, $
              specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d,space_shift=space_shift,nsum=nsum
  
  if keyword_set(no_show_ds9) EQ 0 && ~ keyword_set(non_interactive) then begin
     show_aperture_on_ds9,specimage_bg,source_table,space_shift=space_shift,nsum=nsum
     show_aperture_on_ds9,refimage_bg,source_table,/IMAG,space_shift=space_shift,nsum=nsum
  endif
  
  process_header,specheader,imagheader,source_table,specheader_extract,imagheader_extract

  write_all_output,source_table,space_profile,spec_profile,wave_array,specimage_fc_1d, $
                   refimage_bg,specimage_bg, $
                   refimage_n_bg,refimage_n_bg_short, $
                   specimage_n_sff,specimage_n_sff_short, $
                   specimage_n_wc,specimage_n_wc_short, $
                   specimage_n_fc,specimage_n_fc_short, $
                   res_refimage_bg,res_specimage_bg, $
                   mask_refimage,mask_specimage,mask_specimage_n, $
                   imagheader,specheader,imagheader_extract,specheader_extract, $
                   noisemap,noisemap_n,noisemap_short_n,noise_mask, $
                   dir=!IRC_SPECRED_DIR.workdir,savefile=savefile,/write_indiv_spec

  print,'Information (irc_specred): The IDL save file is saved as :'+savefile  

  logger->append,['---','All done.']
; Common plot param definitions here.
  !X.STYLE=1 & !Y.STYLE=17 & !P.PSYM=0 ; 1 (for exact range set) + 16 (/ynozero)
  source_id=0
 
  if keyword_set(make_4d_output) then begin
   
; test for extraction before stacking
     make_image_n_4d,specimage_ff_shift,source_table,specimage_ss_mask_4d
     
     do_skysub_4d,source_table,specimage_ss_mask_4d,mask_specimage_n,specimage_n_bg_4d, $
                  fov_mask=fov_mask, $
                  noisemap_n=noisemap_n,noise_mask=noise_mask
     
; Do lambda_dependent flat_fielding
     do_specflat_4d,specimage_n_bg_4d,source_table,specimage_n_sff_4d
     
; Do wavelength calibration
     do_wavecalib_4d,specimage_n_sff_4d,source_table,specimage_n_wc_4d,wave_array, $
                     use_array=use_array,specbox_y_shift=specbox_y_shift
     
     write_all_output,source_table,space_profile,spec_profile,wave_array,specimage_fc_1d, $
                      refimage_bg,specimage_bg, $
                      refimage_n_bg,refimage_n_bg_short, $
                      specimage_n_sff,specimage_n_sff_short, $
                      specimage_n_wc,specimage_n_wc_short, $
                      specimage_n_fc,specimage_n_fc_short, $
                      res_refimage_bg,res_specimage_bg, $
                      mask_refimage,mask_specimage,mask_specimage_n, $
                      imagheader,specheader,imagheader_extract,specheader_extract, $
                      noisemap,noisemap_n,noisemap_short_n,noise_mask, $
                      dir=!IRC_SPECRED_DIR.workdir,image_4d=specimage_n_wc_4d,savefile=savefile,/write_indiv_spec
  endif

  if keyword_set(message_finish) then begin
     message,'Finish'
  endif else begin
     goto,very_end
  endelse

  check_specimage_shift,specimage_ss_mask_4d,18

;;; some useful commmands

; make_objmask,specimage_n_wc,noisemap_n,objmask_specimage_n

  irc_show_aperture_n_on_ds9,source_table,dummy,specimage_n_wc

; Plot spectra
  plot_spec_with_image,wave_array,specimage_n_wc,mask_specimage_n,source_table,Source_id

  wave_offset=0.5              ; this is just an example.
  change_wave_offset,wave_offset,source_table,$
;wave_offset,specimage_n_sff,source_table,specimage_n_wc,wave_array,specimage_bg,specheader_extract,$
     space_profile,spec_profile,wave_array,specimage_fc_1d, $
     refimage_bg,specimage_bg, $
     refimage_n_bg,refimage_n_bg_short, $
     specimage_n_sff,specimage_n_sff_short, $
     specimage_n_wc,specimage_n_wc_short, $
     specimage_n_fc,specimage_n_fc_short, $
     res_refimage_bg,res_specimage_bg, $
     mask_refimage,mask_specimage,mask_specimage_n, $
     imagheader,specheader,imagheader_extract,specheader_extract, $
     noisemap,noisemap_n,noisemap_short_n,noise_mask, $
     dir=!IRC_SPECRED_DIR.workdir,savefile=savefile,/write_indiv_spec

  irc_edit_aperture_on_ds9,source_table,refimage_n_bg,specimage_n_wc,use_array

; Image QL

  irc_show_aperture_n_on_ds9,source_table,dummy,specimage_n_wc

  source_id=0
  atv,specimage_n_fc[*,*,source_id],/block
  atv,specimage_n_wc[*,*,source_id],/block
  atv,specimage_n_wc[*,*,source_id]*mask_specimage_n[*,*,source_id],/block
  atv,mask_specimage_n[*,*,source_id],/block
  
  atv,refimage_bg,/block
  atv,res_refimage_bg[*,*,1],/block
  atv,mask_refimage,/block
  atv,specimage_bg,/block
  atv,res_specimage_bg[*,*,1],/block
  atv,mask_specimage,/block
  
  set_color
  
; Aperture QL
  show_aperture_on_ds9,specimage_ff[*,*,1],source_table
  show_aperture_on_ds9,specimage_bg,source_table
  show_aperture_on_ds9,refimage_bg,source_table,/IMAG
  
very_end:
  
  if keyword_set(no_message_finish) then OBJ_DESTROY,logger
;  irc_edit_frames_on_ds9,specimage_ff_shift,use_array_tmp,/edit_anyway
  
end
