; chip=0,1,2 for NIR,MIRS,MIRL
; filter=0,1,2 for N2/N3/N4, S7/S11, L17/L21
; grism=0,1 for NP/NG, SG1/SG2, LG1/LG2;

; To compile everything beforehand... do the followings.
; resolve_routine,'IRC_SPECRED' & resolve_all,/continue_on_error
; !quiet=1 for quiet compiling

;
; Sub-programs for IRC_SPECRED analyses.
; This is only for IRC calibration specialists.
;

; make space_profile/spec_profile
if slit_mode EQ 0 then make_spec_space_prof,refimage_n_bg,source_table,space_profile,spec_profile
  
; revise target table --- tune pos and write target table

read_fits,refimage_bg,header
show_aperture_on_ds9,refimage_bg,source_table,/IMAG,header=header;,/median
get_ds9_region,x,y
tune_sourcepos,refimage_bg,x,y,xnew,ynew,box_half_size=5
make_default_source_table,source_table,n_elements(xnew)
source_table.image_x=xnew & source_table.image_y=ynew
show_aperture_on_ds9,refimage_bg,source_table,/IMAG,header=header;,/median
write_target_table,source_table,dir=workdir,targetid=targetid,targetsubid=targetsubid,filter_spec=filter_spec

; procedure for SPICY
read_fits,refimage_bg,header
show_aperture_on_ds9,refimage_bg,source_table,/IMAG,header=header;,/median
; mark sources on ds9
get_ds9_region,x,y
tune_sourcepos,refimage_bg,x,y,xnew,ynew,box_half_size=5
make_default_source_table,source_table,n_elements(xnew)
source_table.image_x=xnew & source_table.image_y=ynew
; check results on ds9
show_aperture_on_ds9,refimage_bg,source_table,/IMAG,header=header;,/median
; use ds9 save manu to save region in ra-dec format

; oplot IRS spectra
read_irsspec,lambda_template0,flux_template0,d_flux_template0
coadd_irsspec,lambda_template0,flux_template0,d_flux_template0,lambda_template,flux_template
redshift_spec,lambda_template,flux_template,0.07,0.080,lambda_template2,flux_template2 & oplot,lambda_template2,flux_template2,color=green
oplot,lambda_template2,flux_template2,psym=10,color=green,title='z=0.07'

; Make a response function
nsum=15
source_id=63
make_response,wave_array,specimage_n_sff,mask_specimage_n,source_table,source_id,whole_aperture=0,space_shift=space_shift,nsum=nsum

calc_system_throughput,throughput_lambda,eff
write_throughput,throughput_lambda,eff

; Check response
irc_senscalib,specimage_n_wc,mask_specimage_n,wave_array,source_table,specimage_n_fc,sigma_n_fc
make_spec1d,specimage_n_wc,specimage_n_fc,mask_specimage_n,sigma_n_fc,source_table, $
            specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d,/stdstar_mode,space_shift=space_shift,nsum=nsum
check_stdstar_spec,wave_array,specimage_n_wc,mask_specimage_n,source_table,source_id ; offset_pix=0

; Spec Trace
irc_spectrace,specimage_n_sff,spec_xpos,spec_xpos_fit,fit_flag,a0,a1,a2,weight
source_id=0 & show_trace,specimage_n_sff,source_id,spec_xpos,spec_xpos_fit,weight=weight
                                ; if weight is set, this also plots weight function for debugging.
select_spectrace,specimage_n_sff,spec_xpos,spec_xpos_fit,use_array
write_ircdistdata,source_table,a0,a1,a2,use_array

; Fit and find the coefficients a0=polynomial_func (coef_a0,xi,yi), etc.
specdist_fit,source_table,use_array,a0,a1,a2,coef_a0,coef_a1,coef_a2
write_ircdistfitparam,coef_a0,coef_a1,coef_a2


; Line ID and find wavelength solution
plot_spec_with_errorbar,wave_array,specimage_n_wc,mask_specimage_n,source_table,source_id;,offset_pix=0,/wc_mode,smooth_width=3,width=3
; Check sub-pix shift for wavelen; quick image check
d_wave_offset_pix=source_table.spec_y-round(source_table.spec_y)
plot,d_wave_offset_pix[use_array],specbox_y_shift,psym=6,color=white,xstyle=1,ystyle=1,xrange=[-0.5,0.5],yrange=[median(specbox_y_shift)-2.0,median(specbox_y_shift)+2.0]
oplot,d_wave_offset_pix[use_array],specbox_y_shift-d_wave_offset_pix[use_array],psym=4,color=red
print,robust_sigma_mod(specbox_y_shift),robust_sigma_mod(specbox_y_shift-d_wave_offset_pix[use_array])

; if line is saturated..., try this.
correct_saturation,specimage_ff,specimage_ff2
; and do the following processes manually.

make_spec1d,specimage_n_wc,specimage_n_fc,mask_specimage_n,sigmaimage_n_fc,source_table, $
            specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d,/no_mask,space_shift=space_shift,nsum=nsum
irc_wavesol,specimage_wc_1d,source_id
    
; Check NP distortion
make_spec1d,specimage_n_wc,specimage_n_fc,mask_specimage_n,sigmaimage_n_fc,source_table, $
            specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d,/no_mask,/stdstar_mode,space_shift=space_shift,nsum=nsum
calc_np_distortion,specimage_wc_1d,source_table,peak_mean_pos,peak_fit_pos,coef=coef,use_array=use_array
calc_ng_distortion,specimage_wc_1d,source_table,peak_mean_pos,peak_fit_pos
set_spec1d_wc,response_lambda,response

; check specbox shift x
calc_shift_specbox_x,specimage_n_bg,mask_specimage_n,source_table,mean_d_offset,sigma_mean_d_offset

; throughput analysis
irc_throughput_read,lambda,throughput
plot,lambda,throughput,psym=10,color=white,xstyle=1,ystyle=1, $
     xrange=!IRC_SPECRED_SPECPARAM.W_COVER,yrange=[0.,0.5],xtitle='wavelength (um)',ytitle='system throughput'

saveimage,'~/SG1_THROUGHPUT.png',/png

; MISC

make_outliermask,specimage_bg,tmp
;make_outliermask,specflat[*,*,1]/filter_image(specflat[*,*,1],median=3),tmp
write_fits,tmp,dir=calibdir+'/MASK'

write_specbox_shift_y,filename=workdir+'/NP_SPECBOX_SHIFT_Y.dat'
write_specbox_shift_y,filename=workdir+'/NG_SPECBOX_SHIFT_Y.dat'

; plot spectra from data on image

; do param initialize
; at least define !IRC_SPECRED_SPECPARAM.wave_offset_pix and workdir

plot_fits,targetid,targetsubid,ext_source_table,refimage_list,specimage_list,filter_spec,Root_dir=root_dir

read_source_table,source_table,ext_source_table=ext_source_table

read_specbox_shift_y,wave_offset_pix_tmp,filename=workdir+'/NP_SPECBOX_SHIFT_Y.dat'

specimage_n_wc= MRDFITS(filename, 0, hdr, /silent)
mask_specimage_n_wc= MRDFITS(maskfilename, 0, hdr, /silent)

wave_array=get_wavelength()

plot_spec_with_errorbar,wave_array,specimage_n_wc,mask_specimage_n,source_table,source_id


; create NP spec flat for Ns

read_fits,image,header

make_slitflat,image,chip,grism,image_with_slitflat_nan
atv,image_with_slitflat_nan,/block
write_fits,image_with_slitflat_nan,header

; hotpix check

hotpix_region=where(hotpix_image GT 0.)

refdark_bg=refdark_combined-superdark_combined
refdark_bg_long=refdark_bg[*,*,1]
hotpix_refdark=refdark_bg_long[hotpix_region]

refimage_bg_long=refimage_bg[*,*,1]
hotpix_refimage=refimage_bg_long[hotpix_region]

plot,hotpix_refdark,hotpix_refimage,color=red,psym=5,xr=[0,150],yr=[-75,75]


; examine flux calib accuracy

  fileName = DIALOG_PICKFILE (PATH=calibdir+'StdSpecData/', FILTER = '*.tem',title='COHEN STD Stars')
  read_cohen,cohen_lambda,cohen_flux,cohen_d_flux,count,filename
  bin_cohen_spec,cohen_lambda,cohen_flux,cohen_d_flux,wave_array,cohen_flux_bin,cohne_d_flux_bin
  plot,wave_array,cohen_flux_bin,psym=10

  source_id=0
  plot_spec_with_image,wave_array,specimage_n_wc,mask_specimage_n,source_table,17,spa=0,yr=[-5,40],/no_m,wh=0,ns=13,/st,specimage_wc_1d=specimage_wc_1d,specimage_fc_1d=specimage_fc_1d,error_p_fc_total=error_p_fc_total,wave_array_shift=wave_array_shift

  plot,wave_array_shift,specimage_fc_1d*1000,psym=10,xrange=!IRC_SPECRED_SPECPARAM.w_cover
  oplot,wave_array_shift,cohen_flux_bin*1000,psym=10
 
  plot,wave_array_shift,abs(specimage_fc_1d-cohen_flux_bin)/cohen_flux_bin*100.,psym=10,ytitle='fractional error (%)',yr=[0,20],xrange=!IRC_SPECRED_SPECPARAM.w_cover
  oplot,wave_array_shift,error_p_fc_total/cohen_flux_bin*100.,psym=10,color=red




  oplot_line_lambda,7.5,[0,20],wave_array,0.5,linestyle=2,color=red

;calc line flux
;WR133 6.95um
read_irsspec,lambda,flux,d_flux,/watt
plot,lambda,flux,psym=10
plot,flux,psym=10
flux_cut=flux[50:60]
lambda_cut=lambda[50:60]
plot,lambda_cut,flux_cut,psym=10
test=mpfitpeak(lambda_cut,flux_cut,coef,nterms=5,/positive)
sky=coef[3]+coef[4]*lambda_cut
oplot,lambda_cut,sky
d_lambda=lambda_cut-shift(lambda_cut,1)
print,total(flux_cut-sky)*d_lambda[1]


; line width check

