pro irc_wavecalib,specimage_n_sff,source_table,specimage_n_wc,wave_array

; Wavelength calibration of images:
; Transform an observed (distorted) image to a linear (X, Y, Lambda) image.

;
; Input:
;  specimage_n_sff(x,y,source_id) --- Spec-flat fielded image
;  source_table --- source information table
; Output:
;  specimage_n_wc --- Wavelength Calibrated image
;  wave_array --- wavelength along Y (um)

  n_source=n_elements(source_table)
  specimage_n_wc=fltarr(size(specimage_n_sff,/dimensions))
  specimage_n_wc_tmp=fltarr(size(specimage_n_sff,/dimensions))

  dx=findgen(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx)
  dy=findgen(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)
  
  set_spacedistpar,a0,a1,a2
  set_wavedistpar,b0,b1,b2
  
  for source_id=0,n_source-1 do begin
     calc_spacedist,source_table[source_id].image_x,source_table[source_id].image_y,a0,a1,a2,a0_0,a1_0,a2_0
     dx_obs=a0_0+a1_0*dy+a2_0*dy^2.
     
     calc_wavedist, source_table[source_id].image_x,source_table[source_id].image_y,b0,b1,b2,b0_0,b1_0,b2_0
     if NP() then begin
        if !IRC_SPECRED_PROCESSOPTION.NP_linear_mode then $
           dy_obs=(b0_0+b1_0*dy+b2_0*dy^2.)/(b0[0]+b1[0]*dy)*dy-dy $
        else $
           dy_obs=(b0_0+b1_0*dy+b2_0*dy^2.)/(b0[0]+b1[0]*dy+b2[0]*dy^2.)*dy-dy
     endif else $
        dy_obs=(b0_0+b1_0*dy+b2_0*dy^2.)/(b0[0]+b1[0]*dy)*dy-dy ; other grisms
                                ; bunbo uses original (position-independent) values.
     
;  specimage_n_sff[*,*,source_id]=1.0  ; for test only
     tmp=specimage_n_sff[*,*,source_id]
;  tmp[*,*]=1.
     irc_distcalib,tmp,dx_obs,dy_obs,specimage_n_wc_tmp
     specimage_n_wc[*,*,source_id]=specimage_n_wc_tmp
  endfor
  
  wave_array=get_wavelength()
  
end

;memo:
;plot,dy_obs
; x: an array of n_x elements
; y: an array of n_y elements
;dx: an array of n_y elements
;dy: an array of n_x elements
  
