pro ircfind,image,source_table,fwhm, $
            noise_for_find=noise_for_find,interactive=interactive,autonoisecalc=autonoisecalc,skysub=skysub, $
            no_photo=no_photo,only_bright_objects=only_bright_objects,for_skysub_only=for_skysub_only

  common gui,logger

  image_cut=image[!IRC_SPECRED_SOURCEDETECTPARAM.find_area_x1:!IRC_SPECRED_SOURCEDETECTPARAM.find_area_x2, $
                  !IRC_SPECRED_SOURCEDETECTPARAM.find_area_y1:!IRC_SPECRED_SOURCEDETECTPARAM.find_area_y2]

  if keyword_set(skysub) then begin
     irc_calcsky_mmm,image,skymod,skysigma
     image_skysub=image-skymod
     image_cut_skysub=image_cut-skymod
  endif else begin
     image_skysub=image
     image_cut_skysub=image_cut
  endelse

  if NIR() then image_cut_skysub=sigma_filter(image_cut_skysub,radius=2,/iterate,/all,n_sigma=5.) $
  else image_cut_skysub=sigma_filter(image_cut_skysub,radius=1,/iterate,/all,n_sigma=5.)
  
  if keyword_set(autonoisecalc) && (~ defined(noise_for_find)) then begin
     noise_min=!IRC_SPECRED_SOURCEDETECTPARAM.min_noise_for_find
     if ~ defined(skysigma) then skysigma=robust_sigma_mod(image_cut_skysub)
     noise_for_find=skysigma > noise_min
  endif

find_retry:

  find_nan,image_cut_skysub,x,y,flux,sharp,roundness, $
           !IRC_SPECRED_SOURCEDETECTPARAM.sigma*noise_for_find,fwhm+1., $
           !IRC_SPECRED_SOURCEDETECTPARAM.round,!IRC_SPECRED_SOURCEDETECTPARAM.sharp,/silent
  
  if ~ defined(x) || total(x) EQ 0. then begin
     print,'Information (ircfind): No sources were detected! Change detection threshold and retry!'
     noise_for_find*=2./3.
     goto,find_retry
  endif
  
  if keyword_set(only_bright_objects) && n_elements(x) GT !IRC_SPECRED_PROCESSOPTION.max_source_find then begin
     print,'Information (ircfind): Too much sources! Change detection threshold and retry!'
     noise_for_find*=1.5
     goto,find_retry
  endif
  
  do_tune_sourcepos,image_cut_skysub,source_table,x,y,x_new,y_new, $
                    flux=flux,FWHM=measured_FWHM,no_photo=no_photo,for_skysub_only=for_skysub_only ;,/median
  check_image_for_find,image_cut_skysub,x,y,measured_FWHM,use_array,flux=flux

  if use_array[0] EQ -1 then begin
     print,'Warning (ircfind): No sources were detected... Retry!'
;    return
     goto,retry
  endif

  source_table=source_table[use_array]
  
  source_table.image_x+=!IRC_SPECRED_SOURCEDETECTPARAM.find_area_x1
  source_table.image_y+=!IRC_SPECRED_SOURCEDETECTPARAM.find_area_y1
  
  uniq_source_table,source_table,use_array
  
  n_source=n_elements(use_array)
  if n_source EQ 1 && use_array[0] EQ -1 then n_source=0
  if defined(logger) then logger->append,[string(n_source)+' sources were detected.']
  if n_source EQ 0 then begin
     print,'Warning (ircfind): No sources were detected... Retry!'
     goto,retry
  endif
  
  if !IRC_SPECRED_PROCESSOPTION.brightest_10_source_mode then begin ; use only 10 brightest sources for speeding up!
     select_bright_source_table,source_table,10
     return
  endif
  
  if keyword_set(interactive) && !IRC_SPECRED_PROCESSOPTION.non_interactive_mode EQ 0B then begin
     show_aperture_on_ds9,image_skysub,source_table,/IMAG,space_shift=space_shift,nsum=nsum
     do_iteration='dummy'
     while (1) do begin
        retry:
        result=dialog_message('Do another iteration?',/question)
;       read,do_iteration,prompt='Do another iteration? [y/n] '
;       if do_iteration EQ 'n' || do_iteration EQ 'N' || do_iteration EQ 'NO' || do_iteration EQ 'no' then break
        if result NE 'Yes' then break
;       print,sharp,roundness
        params=dialog_input(prompt=["noise","FWHM","Round_Min","Round_Max","Sharp_Min","Sharp_Max"],nfields=6, $
                            initial=[noise_for_find,FWHM, $
                                     !IRC_SPECRED_SOURCEDETECTPARAM.round[0],!IRC_SPECRED_SOURCEDETECTPARAM.round[1], $
                                     !IRC_SPECRED_SOURCEDETECTPARAM.sharp[0],!IRC_SPECRED_SOURCEDETECTPARAM.sharp[1]], $
                            title="Find Param Set")
        if n_elements(params) EQ 6 then begin ; when cancel is not pressed
           noise_for_find=float(params[0]) & FWHM=float(params[1])
           !IRC_SPECRED_SOURCEDETECTPARAM.round[0]=float(params[2])
           !IRC_SPECRED_SOURCEDETECTPARAM.round[1]=float(params[3])
           !IRC_SPECRED_SOURCEDETECTPARAM.sharp[0]=float(params[4])
           !IRC_SPECRED_SOURCEDETECTPARAM.sharp[1]=float(params[5])
        endif                   ; when cancel is pressed, do not chnage noise and FWHM
        
find_retry2:
        find_nan,image_cut_skysub,x,y,flux,sharp,roundness, $
                 !IRC_SPECRED_SOURCEDETECTPARAM.sigma*noise_for_find,fwhm+1., $
                 !IRC_SPECRED_SOURCEDETECTPARAM.round, $
                 !IRC_SPECRED_SOURCEDETECTPARAM.sharp,/silent
        
        if total(x) EQ 0. then begin
           print,'Information (ircfind): No sources were detected! Change detection threshold and retry!'
           noise_for_find*=2./3.
           goto,find_retry2
        endif
        
        do_tune_sourcepos,image_cut_skysub,source_table,x,y,x_new,y_new, $
                          FWHM=measured_FWHM,flux=flux,for_skysub_only=for_skysub_only ;,/median
        check_image_for_find,image_cut_skysub,x,y,measured_FWHM,use_array,flux=flux

        if use_array[0] EQ -1 then begin
           print,'Warning (ircfind): No sources were detected... Retry!'
           continue
        endif

        source_table=source_table[use_array]
        
        source_table.image_x+=!IRC_SPECRED_SOURCEDETECTPARAM.find_area_x1
        source_table.image_y+=!IRC_SPECRED_SOURCEDETECTPARAM.find_area_y1
        
        uniq_source_table,source_table,use_array
        
        n_source=n_elements(use_array)
        if defined(logger) then logger->append,[string(n_source)+' sources were detected.']
        
        show_aperture_on_ds9,image_skysub,source_table,/IMAG,space_shift=space_shift,nsum=nsum
     endwhile
  endif                         ; of interactive loop
  
end
