pro make_default_source_table,source_table,n_source

  If ~ defined(n_source) || n_source EQ 0 then $
     n_source=1                 ; dummy; was !IRC_SPECRED_SOURCEDETECTPARAM.max_n_source
  
  source_table_struct={ $
                      ID:0, $
                    image_x:0., $
                      image_y:0., $
                      image_mask_dx:0, $
                      image_mask_dy:0, $
                      spec_x:0., $
                      spec_y:0., $
                      spec_mask_dx:0, $
                      spec_mask_dy:0, $
                      flux:0., $
                      image_FWHM:0., $
                      spec_bgnoise_ADU:0., $
                      spec_bgnoise_ADU_short:0., $
                      spec_bgnoise_1d_ADU:0., $
;                     spec_bgnoise_1d_ADU_short:0., $
                      spec_1dextract_dx:0, $
                      spec_x_pos:0., $
                      spec_x_FWHM:0., $
                      bad_sourcepos_flag:0B, $
                      np_distortion_offset_y:0. $
                      }
  
  source_table=replicate(source_table_struct,n_source)
  
  source_table.id=indgen(n_source)
  
; Set mask sizes
  if defined(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx) then begin
     source_table[*].spec_mask_dx=!IRC_SPECRED_SPECEXTRACTPARAM.spec_mask_dx_min ; set them minumum; was specaper_dx ; covering whole aperture
     source_table[*].spec_mask_dy=!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy
     source_table.image_mask_dx=source_table.spec_mask_dx
     source_table.image_mask_dy=source_table.spec_mask_dx
  endif
  
end
