function get_source_pos,center_pos,nsum

  case 1 of
     (nsum EQ 1): source_pos=[center_pos]
     (nsum EQ 2): source_pos=[center_pos,center_pos+1]
     (nsum EQ 3): source_pos=[center_pos-1,center_pos,center_pos+1]
     (nsum EQ 4): source_pos=[center_pos-1,center_pos,center_pos+1,center_pos+2]
     (nsum EQ 5): source_pos=[center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2]
     (nsum EQ 6): source_pos=[center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2,center_pos+3]
     (nsum EQ 7): source_pos=[center_pos-3,center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2,center_pos+3]
     (nsum EQ 8): source_pos=[center_pos-3,center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2,center_pos+3, $
                              center_pos+4]
     (nsum EQ 9): source_pos=[center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2,center_pos+3, $
                              center_pos+4]
     (nsum EQ 10): source_pos=[center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2,center_pos+3, $
                               center_pos+4,center_pos+5]
     (nsum EQ 11): source_pos=[center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2, $
                               center_pos+3,center_pos+4,center_pos+5]
     (nsum EQ 12): source_pos=[center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2, $
                               center_pos+3,center_pos+4,center_pos+5,center_pos+6]
     (nsum EQ 13): source_pos=[center_pos-6,center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2, $
                               center_pos+3,center_pos+4,center_pos+5,center_pos+6]
     (nsum EQ 14): source_pos=[center_pos-6,center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos,center_pos+1,center_pos+2, $
                               center_pos+3,center_pos+4,center_pos+5,center_pos+6,center_pos+7]
     (nsum EQ 15): source_pos=[center_pos-7,center_pos-6,center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos, $
                               center_pos+1,center_pos+2,center_pos+3,center_pos+4,center_pos+5,center_pos+6,center_pos+7]
     (nsum EQ 16): source_pos=[center_pos-7,center_pos-6,center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos, $
                               center_pos+1,center_pos+2,center_pos+3,center_pos+4,center_pos+5,center_pos+6,center_pos+7,center_pos+8]
     (nsum EQ 17): source_pos=[center_pos-8,center_pos-7,center_pos-6,center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos, $
                               center_pos+1,center_pos+2,center_pos+3,center_pos+4,center_pos+5,center_pos+6,center_pos+7,center_pos+8]
     (nsum EQ 18): source_pos=[center_pos-8,center_pos-7,center_pos-6,center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos, $
                               center_pos+1,center_pos+2,center_pos+3,center_pos+4,center_pos+5,center_pos+6,center_pos+7,center_pos+8,center_pos+9]
     (nsum EQ 19): source_pos=[center_pos-9,center_pos-8,center_pos-7,center_pos-6,center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos, $
                               center_pos+1,center_pos+2,center_pos+3,center_pos+4,center_pos+5,center_pos+6,center_pos+7,center_pos+8,center_pos+9]
     (nsum EQ 20): source_pos=[center_pos-9,center_pos-8,center_pos-7,center_pos-6,center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos, $
                               center_pos+1,center_pos+2,center_pos+3,center_pos+4,center_pos+5,center_pos+6,center_pos+7,center_pos+8,center_pos+9,center_pos+10]
     (nsum EQ 21): source_pos=[center_pos-10,center_pos-9,center_pos-8,center_pos-7,center_pos-6,center_pos-5,center_pos-4,center_pos-3,center_pos-2,center_pos-1,center_pos, $
                               center_pos+1,center_pos+2,center_pos+3,center_pos+4,center_pos+5,center_pos+6,center_pos+7,center_pos+8,center_pos+9,center_pos+10]
     
     else: source_pos=[center_pos-1,center_pos,center_pos+1] ; default
  endcase

  return,source_pos

end

pro set_source_pos,source_table,source_id,center_pos,source_pos,space_shift,nsum, $
                   stdstar_mode=stdstar_mode,whole_aperture=whole_aperture,bg_mode=bg_mode

  xarray=findgen(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx)
  if (!IRC_SPECRED_OBSPARAM.slit_mode EQ 0B) || (!IRC_SPECRED_OBSPARAM.slit_mode && defined(nsum)) then begin
     if keyword_set(stdstar_mode) && keyword_set(whole_aperture) then begin
                                ; whole aperture setting
        source_pos=xarray
        if ~ keyword_set(bg_mode) then source_table[source_id].spec_1dextract_dx=!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx
     endif else begin
        center_pos=source_table[source_id].spec_x_pos+space_shift
        source_pos=get_source_pos(center_pos,nsum)
         if ~ keyword_set(bg_mode) then source_table[source_id].spec_1dextract_dx=nsum
     endelse
     
  endif else begin              ; for slit mode for all
     source_pos=xarray
     source_table[source_id].spec_1dextract_dx=!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx
  endelse
end


pro make_spec1d,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
                specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d,sigmaimage_ADU_1d, $
                space_shift=space_shift,nsum=nsum, $
                stdstar_mode=stdstar_mode,no_mask=no_mask,average_mode=average_mode,whole_aperture=whole_aperture, $
                noise_plot_only=noise_plot_only,short=short,bg_mode=bg_mode

;  common measured_offsets,space_shift,nsum
  
; sigmaimage_fc_1d: sigma of each image at given lambda in flux units,
; converted for summed 1d image: fltarr(specaper_dy,n_source)
; sigmaimage_ADU_1d: sigma of each image at given lambda in ADU units,
; converted for summed 1d image: fltarr(specaper_dy,n_source)
  
  s=size(specimage_n_wc) & ysize=s[2]
  n_source=n_elements(source_table)

  if ~ defined(space_shift) then space_shift=0
  if ~ defined(nsum) then nsum=3
; if ~ defined(specmask_n) then specmask_n_use=make_array(size(specimage_n_wc,/dimensions),/float,value=1.)

; even if no_mask option is set, the out-of-FOV area will be masked out.
  if keyword_set(no_mask) then begin
     specmask_n_use=make_array(size(specimage_n_wc,/dimensions),/float,value=1.)
     for source_id=0,n_source-1 do begin
        for y=0,ysize-1 do begin
           if total(specimage_n_wc[*,y,source_id]) EQ 0. then $
              specmask_n_use[*,y,source_id]=!values.f_nan
        endfor
     endfor
  endif else begin
     if ~ defined(specmask_n) then specmask_n_use=make_array(size(specimage_n_wc,/dimensions),/float,value=1.) $
     else specmask_n_use=specmask_n
  endelse

  specimage_wc_1d=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,n_source)
  specimage_fc_1d=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,n_source)
  sigmaimage_fc_1d=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,n_source)
  sigmaimage_ADU_1d=fltarr(n_source)
  
  for source_id=0,n_source-1 do begin
     set_source_pos,source_table,source_id,center_pos,source_pos,space_shift,nsum, $
                    stdstar_mode=stdstar_mode,whole_aperture=whole_aperture,bg_mode=bg_mode

     specimage_wc_1d[*,source_id]=total(specimage_n_wc[source_pos,*,source_id]*specmask_n_use[source_pos,*,source_id],1,/NAN)

;     if NP() then begin
;        set_source_pos,source_table,source_id,center_pos,source_pos2,space_shift,nsum+6,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture
;        specimage_wc_1d_tmp=total(specimage_n_wc[source_pos2,*,source_id]*specmask_n_use[source_pos2,*,source_id],1,/NAN)
;        specimage_wc_1d[0:20,source_id]=specimage_wc_1d_tmp[0:20]
;     endif
     
     if defined(specimage_n_fc) then begin
;       specimage_n_fc_smooth=filter_image(specimage_n_fc[*,*,source_id],median=3)
           specimage_fc_1d[*,source_id] =total(specimage_n_fc[source_pos,*,source_id]*specmask_n_use[source_pos,*,source_id],1,/NAN)
           sigmaimage_fc_1d[*,source_id]=total(sigmaimage_n_fc[source_pos,*,source_id]*specmask_n_use[source_pos,*,source_id],1,/NAN)/sqrt(n_elements(source_pos))           
;
; Added by Shinki Oyabu at 2010/09/05
;
           if !IRC_SPECRED_OBSPARAM.SLIT_MODE eq 1 then begin
              for i=0,n_elements(specimage_fc_1d[*,source_id])-1 do begin
                 tempimg=specimage_n_fc[source_pos,*,source_id]*specmask_n_use[source_pos,*,source_id]
                 pos_nan=where(finite(tempimg[*,i,source_id],/nan),cnt_nan)
                 if nsum gt cnt_nan then specimage_fc_1d[i,source_id] = specimage_fc_1d[i,source_id]*nsum/(nsum-cnt_nan)                 
                 tempimg2=sigmaimage_n_fc[source_pos,*,source_id]*specmask_n_use[source_pos,*,source_id]
                 pos_nan=where(finite(tempimg2[*,i,source_id],/nan),cnt_nan)
                 if nsum gt cnt_nan then sigmaimage_fc_1d[i,source_id] = sigmaimage_fc_1d[i,source_id]*sqrt(nsum)/sqrt(nsum-cnt_nan)                 
              endfor
           endif
;
; End
;
     endif
     
     if keyword_set(average_mode) then begin
        specimage_wc_1d[*,source_id]/=n_elements(source_pos)
        specimage_fc_1d[*,source_id]/=n_elements(source_pos)
     endif

     if ~ keyword_set(short) then $
        source_table[source_id].spec_bgnoise_1d_ADU=source_table[source_id].spec_bgnoise_ADU*sqrt(n_elements(source_pos)) $
     else $
        source_table[source_id].spec_bgnoise_1d_ADU=source_table[source_id].spec_bgnoise_ADU_short*sqrt(n_elements(source_pos))

  endfor
  
end
