pro make_spec_space_prof,image3d,source_table,space_profile,spec_profile, $
                         for_specimage=for_specimage

; Calc spec/space profiles of image3d (the extracted and 3d-stacked image)
; Target mask will be considered.

s=size(image3d) & xsize=s[1] & ysize=s[2]
if s[0] EQ 2 then n_source=1 else n_source=s[3]; when 2D image is set, n_source should be 1, not s[3]

space_profile=fltarr(xsize,n_source) & spec_profile=fltarr(ysize,n_source)
mask_dx=fltarr(n_source) & mask_dy=fltarr(n_source)
if keyword_set(for_specimage) then begin
    mask_dx=source_table.spec_mask_dx
    mask_dy=source_table.spec_mask_dy
endif else begin
   mask_dx=source_table.image_mask_dx
   mask_dy=source_table.image_mask_dy
endelse

if keyword_set(for_specimage) then make_mask_n,source_table,specmask3d $
else                               make_mask_n,source_table,specmask3d,/circular_aperture

for source_id=0,n_source-1 do begin

; calc profile, while considering masked regions
; for space profle

   for x=0,xsize-1 do begin
      sum_range=where(specmask3d[x,*,source_id] EQ 1,count)
      if count NE 0 then $
         space_profile[x,source_id]=total(image3d[x,sum_range,source_id],/NAN)/count $
      else $
         space_profile[x,source_id]=0.
   endfor
   
; for spec profile
    for y=0,ysize-1 do begin
       sum_range=where(specmask3d[(xsize-1)/2-(mask_dx[source_id]-1)/2>1:(xsize-1)/2+(mask_dx[source_id]-1)/2<(xsize-1), $
                                  y,source_id] EQ 1,count) ; exclude 1st raw to remove gomi after wavecalib
       if count NE 0 then begin
          spec_profile[y,source_id]= $
             total(image3d[sum_range,y,source_id],/NAN) / $
             (total(space_profile[sum_range,source_id],/NAN)/total(space_profile[*,source_id],/NAN))
;             flux correction factor in spec image, based on image info.
          if keyword_set(for_specimage) then $
             print,'fraction of flux included within the specified mask size dx:',source_id,y, $
                   count,(total(space_profile[sum_range,source_id],/NAN)/total(space_profile[*,source_id],/NAN))
       endif else begin
          spec_profile[y,source_id]=0.
       endelse
    endfor
    
 endfor                         ; of source_id loop

end
