PRO plot_spec_all,lambda,flux, $
                  nx=nx,ny=ny,id1=id1,id2=id2,title=title,PS=PS,_EXTRA=EXTRA_KEYWORDS

  if ~ keyword_set(nx) || ~ keyword_set(ny) then begin
     nx=3 & ny=3
  endif
  if ~ keyword_set(title) then title='IRC_SPECRED'
  
  !p.multi=[0,nx,ny]
  
  if keyword_set(PS) then begin
     mydevice = !D.NAME
     SET_PLOT, 'PS'
     DEVICE, FILENAME=!IRC_SPECRED_DIR.tmpdir+'/'+strcompress(title,/remove)+'.ps', /LANDSCAPE,/color
  endif else begin
     window,title=title,xsize=800,ysize=600
  endelse
  
  s=size(flux) & if s[0] EQ 1 then n_source=1 else n_source=s[2]
  s=size(lambda)
  
  if keyword_set(id1) EQ 0 then id1=0
  if keyword_set(id2) EQ 0 then id2=n_source
  
  for source_id=id1,id2 do begin
     if s[0] EQ 2 then begin    ; if flux is a 2D array...
        plot,lambda[*,source_id],flux[*,source_id], $
             ytitle='Flux (Jy)',xtitle='Lambda (um)',xstyle=1,xrange=w_cover,psym=10,color=!IRC_SPECRED_COLOR.white,$
             title=strcompress(string(source_id),/remove),_extra=extra_keywords
     endif else begin           ; if flux is a 1D array...
        plot,lambda,flux[*,source_id], $
             ytitle='Flux (Jy)',xtitle='Lambda (um)',xstyle=1,xrange=w_cover,psym=10,color=!IRC_SPECRED_COLOR.white,$
             title=strcompress(string(source_id),/remove),_extra=extra_keywords
     endelse
  endfor
  
  if keyword_set(PS) then begin
     DEVICE, /CLOSE_FILE        ; Return plotting to the original device:
     SET_PLOT, mydevice
  endif
  
  !p.multi=0
  
END
