pro plot_spec_with_image,wave_array,specimage_n_wc,specmask_n,source_table,source_id, $
                         smooth_width=smooth_width,nsum=nsum,space_shift=space_shift, $
                         no_mask=no_mask,no_source_mask=no_source_mask,short=short,$
; pre-filter
                         sigma_filter_set=sigma_filter_set, $
; maintenance option
                         offset_pix=offset_pix,average_mode=average_mode, $
; background process option
                         bg_show=bg_show,bg_sub=bg_sub,bg_nsum=bg_nsum,bg_offset=bg_offset,bg_oneside=bg_oneside, $
; stdstar mode
                         stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
; template overlay
                         lambda_template=lambda_template,flux_template=flux_template,z_template=z_template, $
                         scale_template=scale_template,redshift=redshift, $
; flux unit
                         watt=watt,wc_mode=wc_mode,diffuse=diffuse,lambda2=lambda2, $
; special plot option
                         oplot=oplot,clip_range=clip_range, $
; TV option
                         with_image=with_image,tvbottom=tvbottom,tvtop=tvtop,dir=dir, $
; noise plot
                         noise_plot_only=noise_plot_only, $
                         no_shotnoise=no_shotnoise, $
                         no_wavelength_shift_error=no_wavelength_shift_error, $
                         flux_error_plot=flux_error_plot, $
; noise output
                         noisemap_long=noisemap_long,noisemap_short=noisemap_short, $
; output
                         PS=PS,PNG=PNG,ASCII=ASCII, $
                         wave_array_shift=wave_array_shift,error_p_fc_total=error_p_fc_total, $
                         specimage_wc_1d_smooth=specimage_wc_1d_smooth, $
                         specimage_fc_1d_smooth=specimage_fc_1d_smooth, $
; extra & misc
                         _EXTRA=EXTRA_KEYWORDS,winid=winid,xpos=xpos,ypos=ypos, $
                         space_smooth=space_smooth,bin=bin,plot_color=plot_color, $
                         no_aperture_correction=no_aperture_correction,spicy=spicy, $
                         no_reliable_range=no_reliable_range, $
                         median_width=median_width,fwhm=fwhm,three_sigma=three_sigma

; param check
  if ~ defined(specimage_n_wc) then begin
     print,'Warning (plot_spec_with_image): input array (specimage_n_wc) is undefined!'
     return
  endif

  if ~ defined(specmask_n) then begin
     print,'Warning (plot_spec_with_image): input array (specmask_n) is undefined!'
     return
  endif
  
  s=size(specimage_n_wc) & if s[0] EQ 3 then n_source=s[3] else n_source=1

  if ~ defined(source_id) then begin
     print,'Warning (plot_spec_with_image): source id is not defined! source_id=0 is assumed.'
     source_id=0
  endif

  if source_id GT n_source-1 then begin
     print,'Warning (plot_spec_with_image): invalid source_id!'
     return
  endif
  
; specmask_n_org=specmask_n

  if keyword_set(spicy) then begin
; This is for multi-pointing-stacked mask
     if keyword_set(no_source_mask) then $
        specmask_n_work=specmask_n $ ; make_array(size(specimage_n_wc,/dimensions),/float,value=1.) $
     else begin
        make_mask_n,source_table,specmask_n_work
        specmask_n_work*=specmask_n
     endelse
  endif else begin
     if keyword_set(no_mask) then begin
        specmask_n_work= make_array(size(specimage_n_wc,/dimensions),/float,value=1.)
;    atv,specmask_n_work[*,*,source_id],/b
     endif else begin
        make_mask_n,source_table,specmask_n_work
;    atv,specmask_n_work[*,*,source_id],/b
     endelse
  endelse

  if (~ keyword_set(watt)) && (~ keyword_set(diffuse)) && (~ keyword_set(lambda2)) then mjy=1B
  
; if ~ defined(bg_nsum) then bg_nsum=1
  if ~ defined(bg_offset) then bg_offset=10
  if defined(smooth_width) then begin
     if smooth_width EQ 0 then smooth_width=1; width=1 means no smoothing
     !IRC_SPECRED_PLOTPARAM.smooth=smooth_width
  endif else !IRC_SPECRED_PLOTPARAM.smooth=1

  if defined(bin) then !IRC_SPECRED_PLOTPARAM.smooth=bin

  set_color,/white_bg
  margin=0.1
  get_winsize_for_plot,x_winsize,y_winsize

  if ~ defined(winid) then winid=0
  if ~ defined(oplot) then begin
     if !d.window EQ -1 then window,xsize=x_winsize,ysize=y_winsize else window,winid,xsize=x_winsize,ysize=y_winsize,xpos=xpos,ypos=ypos
  endif

  if keyword_set(with_image) then begin
     !p.position=[margin,0.5+margin,1.0-margin,1.0-margin] ; set the draw area to be upper half
  endif else begin
     !p.position=0
  endelse
  
  y_shift=1.0                   ; statistical error of Y pos; was 0.5
  
  if defined(PS) then begin
     pson, FILENAME=!IRC_SPECRED_DIR.workdir+'/'+PS+'.ps',/landscape,paper='A4',margin=0.
     print,'Writing on a PS file'
  endif
  
  if ~ defined(source_id) then source_id=0
  if ~ defined(redshift) then redshift=0.
  if ~ defined(offset_pix) then offset_pix=0.
; if defined(nsum_keyword) then nsum=nsum_keyword
  if ~ defined(nsum) then nsum=3
; if defined(space_shift) then space_shift=space_shift_keyword
; if ~ defined(space_shift) then space_shift=0
; if ~ defined(specmask_n) then specmask_n=make_array(size(specimage_n_wc,/dimensions),/float,value=1.) ; make a dummy mask cube
  if ~ defined(whole_aperture) then whole_aperture=1

  if defined(sigma_filter_set) then begin
;    specimage_n_wc_med=sigma_filter_cube(specimage_n_wc,3)
     specimage_n_wc_med=loess_filter_cube(specimage_n_wc,3,1,source_id=source_id)
     smooth_fac=3
  endif else begin
     specimage_n_wc_med=specimage_n_wc
  endelse

  case 1 of
     defined(fwhm): begin
        specimage_n_wc_med=gausscube(specimage_n_wc_med,fwhm)
        smooth_fac=3
     end
     defined(median_width): begin
        specimage_n_wc_med=medcube(specimage_n_wc_med,3)
        smooth_fac=median_width
     end
     else: begin
        specimage_n_wc_med=specimage_n_wc_med
        smooth_fac=1
     end
  endcase

;  if ~ keyword_set(tvtop) then tvtop=10
;  if ~ keyword_set(tvbottom) then tvbottom=-1

; aperture correction

  if ~ defined(no_aperture_correction) && ~ defined(diffuse) then begin
     set_apcor,width,frac,frac_err
     fracid=where(width EQ nsum, count)
     if count GT 0 then apcor_fac=frac(fracid) else apcor_fac=1.
     apcor_fac=apcor_fac[0]
  endif else apcor_fac=1.

  specimage_n_wc_med/=apcor_fac

  if NG() || LG2() then d_wave_offset_pix=-(source_table.spec_y-round(source_table.spec_y)) $
  else                  d_wave_offset_pix=-(source_table.spec_y-round(source_table.spec_y)) ; negative LG2 diseprsion
  
;check response systematic error
  shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id]        ,wave_array_shift
  irc_senscalib,specimage_n_wc_med,specimage_n_wc_med,specmask_n_work,wave_array_shift,source_table, $
                specimage_n_fc,specimage_n_fc_short,   sigmaimage_n_fc,sigmaimage_n_fc_short, $
                /no_logger_out,no_shotnoise=no_shotnoise,noisemap_long=noisemap_long,noisemap_short=noisemap_short

;atv,specmask_n_work[*,*,source_id],/b

  shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id]+y_shift,wave_array_shift
  irc_senscalib,specimage_n_wc_med,specimage_n_wc_med,specmask_n_work,wave_array_shift,source_table, $
                specimage_n_fc_p1,specimage_n_fc_p1_short,sigmaimage_n_fc_p1,sigmaimage_n_fc_p1_short, $
                /no_logger_out,no_shotnoise=no_shotnoise
  
  shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id]-y_shift,wave_array_shift
  irc_senscalib,specimage_n_wc_med,specimage_n_wc_med,specmask_n_work,wave_array_shift,source_table, $
                specimage_n_fc_n1,specimage_n_fc_n1_short,sigmaimage_n_fc_n1,sigmaimage_n_fc_n1_short, $
                /no_logger_out,no_shotnoise=no_shotnoise
  
  shift_wavelength,wave_array,offset_pix+d_wave_offset_pix[source_id],wave_array_shift

  if keyword_set(short) then begin
     specimage_n_fc=   specimage_n_fc_short
     specimage_n_fc_p1=specimage_n_fc_p1_short
     specimage_n_fc_n1=specimage_n_fc_n1_short
     sigmaimage_n_fc=sigmaimage_n_fc_short
  endif
  
  make_spec1d,specimage_n_wc_med,specimage_n_fc_p1,specmask_n_work,sigmaimage_n_fc,source_table, $
              specimage_wc_p1_1d,specimage_fc_p1_1d,sigmaimage_fc_1d_tmp, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
              noise_plot_only=noise_plot_only,average_mode=avearege_mode,short=short, $
              space_shift=space_shift,nsum=nsum

  make_spec1d,specimage_n_wc_med,specimage_n_fc_n1,specmask_n_work,sigmaimage_n_fc,source_table, $
              specimage_wc_n1_1d,specimage_fc_n1_1d,sigmaimage_fc_1d_tmp, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
              noise_plot_only=noise_plot_only,average_mode=avearege_mode,short=short, $
              space_shift=space_shift,nsum=nsum

  make_spec1d,specimage_n_wc_med,specimage_n_fc,specmask_n_work,sigmaimage_n_fc,source_table, $
              specimage_wc_0_1d,specimage_fc_0_1d,sigmaimage_fc_1d_tmp, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
              noise_plot_only=noise_plot_only,average_mode=avearege_mode,short=short, $
              space_shift=space_shift,nsum=nsum

  make_spec1d,specimage_n_wc_med,specimage_n_fc,specmask_n_work,sigmaimage_n_fc,source_table, $
              specimage_wc_1d,specimage_fc_1d,sigmaimage_fc_1d, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,whole_aperture=whole_aperture, $
              noise_plot_only=noise_plot_only,average_mode=avearege_mode,short=short, $
              space_shift=space_shift,nsum=nsum

  make_offspec_for_plot,specimage_n_wc_med,specimage_n_fc,specmask_n_work,sigmaimage_n_fc,source_table,source_id, $
                        off_specimage_wc_1d,off_specimage_fc_1d, $
                        bg_nsum=bg_nsum,bg_sub=bg_sub,bg_offset=bg_offset,no_mask=no_mask,average_mode=average_mode, $
                        stdstar_mode=stdstar_mode,whole_aperture=whole_aperture,bg_oneside=bg_oneside,short=short, $
                        space_shift=space_shift,nsum=nsum

  calc_noise_for_plot, $
     sigmaimage_fc_1d,specimage_fc_p1_1d,specimage_fc_n1_1d,specimage_fc_0_1d,source_table,source_id,bg_nsum, $
     error_p_wc_total,error_n_wc_total,error_p_wc_total_bg,error_n_wc_total_bg, $
     shift_error_p_fc,shift_error_n_fc,error_p_fc_total,error_n_fc_total, $
     no_wavelength_shift_error=no_wavelength_shift_error,three_sigma=three_sigma,apcor_fac=apcor_fac

; calc error X corresponding to y_shift pixel shift
  shift_wavelength,wave_array_shift,y_shift,wave_array_shift_1
  d_wave_array=abs(wave_array_shift_1-wave_array_shift)
  
  if defined(bin) then begin
     do_bin_spec_for_plot, $
        specimage_fc_1d,off_specimage_fc_1d,specimage_wc_1d,off_specimage_wc_1d,source_id, $
        specimage_wc_1d_smooth,specimage_fc_1d_smooth,off_specimage_fc_1d_smooth,off_specimage_wc_1d_smooth, $
        error_n_wc_total,error_p_wc_total,error_n_fc_total,error_p_fc_total,error_n_wc_total_bg,error_p_wc_total_bg, $
        smooth_fac=smooth_fac,bg_sub=bg_sub,wave_array_org=wave_array_shift,wave_array_bin=wave_array_bin_shift
     wave_array_shift=wave_array_bin_shift
  endif else begin
     do_smooth_spec_for_plot, $
        specimage_fc_1d,off_specimage_fc_1d,specimage_wc_1d,off_specimage_wc_1d,source_id, $
        specimage_wc_1d_smooth,specimage_fc_1d_smooth,off_specimage_fc_1d_smooth,off_specimage_wc_1d_smooth, $
        error_n_wc_total,error_p_wc_total,error_n_fc_total,error_p_fc_total,error_n_wc_total_bg,error_p_wc_total_bg, $
        smooth_fac=smooth_fac,bg_sub=bg_sub
  endelse

; print,off_specimage_fc_1d_smooth[*,source_id]

; Make pretty plots
  
  !X.STYLE=1 & !Y.STYLE=17      ; 1 (for exact range set) + 16 (/ynozero)

  if keyword_set(with_image) then $
     x_range_set=[wave_array_shift[0],wave_array_shift[n_elements(wave_array_shift)-1]] $
  else $
     x_range_set=!IRC_SPECRED_SPECPARAM.w_cover

  if NG() || LG2() then x_range_set=[x_range_set[1],x_range_set[0]]

  case 1 of
     (keyword_set(wc_mode)): begin
;        if keyword_set(with_image) then begin
           plot_spec,wave_array_shift,specimage_wc_1d_smooth,psym=10,color=!IRC_SPECRED_COLOR.white,_extra=extra_keywords, $
                     xrange=x_range_set,$
                     oplot=oplot,clip_range=clip_range,space_shift=space_shift,nsum=nsum,/WC

           set_response,lambda,response,d_response,response_file=response_file
           if defined(yrange) then y_max=yrange[1] else y_max=max(specimage_wc_1d_smooth,/nan)
           oplot,lambda,response/max(response)*y_max,color=!IRC_SPECRED_COLOR.red

;        endif else begin
;           plot_spec,wave_array_shift,specimage_wc_1d_smooth,psym=10,color=!IRC_SPECRED_COLOR.white,_extra=extra_keywords, $
;                     xrange=x_range_set,$
;                     oplot=oplot,clip_range=clip_range,space_shift=space_shift,nsum=nsum
;        endelse
        oplot,[2.4,2.4],[-1e6,1e6], $
              color=!IRC_SPECRED_COLOR.green,_extra=extra_keywords ; was [-1e6,1e6]

        plot_spec,wave_array_shift,specimage_wc_1d_smooth+error_n_wc_total,specimage_wc_1d_smooth-error_n_wc_total, $
                  color=!IRC_SPECRED_COLOR.red,/errory,clip_range=clip_range,nsum=nsum
        plot_spec,wave_array_shift,fltarr(n_elements(wave_array_shift)), $
                  linestyle=2,color=!IRC_SPECRED_COLOR.green,_extra=extra_keywords,/oplot, $
                  clip_range=clip_range,space_shift=space_shift,nsum=nsum

        if keyword_set(bg_show) then begin
           oplot,wave_array_shift,off_specimage_wc_1d_smooth, $
                 color=!IRC_SPECRED_COLOR.yellow,psym=10,_extra=extra_keywords ;,clip_range=clip_range
           plot_spec,wave_array_shift,off_specimage_wc_1d_smooth+error_n_wc_total_bg, $
                     off_specimage_wc_1d_smooth,error_n_wc_total_bg, $
                     color=!IRC_SPECRED_COLOR.yellow,/errory,clip_range=clip_range, $
                     xrange=x_range_set,space_shift=space_shift,nsum=nsum
        endif
     end
     
     (keyword_set(noise_plot_only)): begin
; correction factor for AOT04c
;case (1) of
;   NP(): noise_fac=1./sqrt(2.)
;   NG(): noise_fac=1./sqrt(2.)
;   SG1(): noise_fac=1./sqrt(2.)
;   SG2(): noise_fac=1./sqrt(2.)
;   LG2(): noise_fac=1.
;endcase
        noise_fac=1.
        plot_spec,wave_array_shift,error_p_fc_total*noise_fac, $
                  color=!IRC_SPECRED_COLOR.white,psym=10,mjy=mjy,watt=watt,lambda2=lambda2, $
                  ytitle='1-sigma noise-equivalent flux (mJy)',with_image=with_image,clip_range=clip_range, $
                  space_shift=space_shift,nsum=nsum,_extra=extra_keywords
        plot_spec,wave_array_shift,shift_error_p_fc*noise_fac, $
                  color=!IRC_SPECRED_COLOR.blue,psym=10,/oplot,mjy=mjy,watt=watt,lambda2=lambda2, $
                  clip_range=clip_range,space_shift=space_shift,nsum=nsum,_extra=extra_keywords
     end
     
     else: begin
        if ~ defined(stdstar_mode) then begin

;          print,wave_array_shift,error_n_fc_total*1000.;,error_n_fc_total*1000.
           plot_spec_obs,wave_array_shift,specimage_fc_1d_smooth,error_p_fc_total,error_n_fc_total,d_wave_array, $
;          plot_spec_obs,wave_array_shift,off_specimage_fc_1d,error_p_fc_total,error_n_fc_total,d_wave_array, $
                         redshift=redshift,mjy=mjy,watt=watt,diffuse=diffuse,lambda2=lambda2, $
                         _extra=extra_keywords,with_image=with_image,oplot=oplot,clip_range=clip_range, $
                         space_shift=space_shift,nsum=nsum,plot_color=plot_color,x_range_set=x_range_set
        endif else begin
           fileName = DIALOG_PICKFILE (PATH=!IRC_SPECRED_DIR.calibdir+'StdSpecData/', $
                                       FILTER = '*.tem',title='COHEN STD Stars')
           read_cohen,cohen_lambda,cohen_flux,cohen_d_flux,count,filename
           if keyword_set(flux_error_plot) then begin
              bin_cohen_spec,cohen_lambda,cohen_flux,cohen_d_flux,wave_array_shift,cohen_flux_bin,cohne_d_flux_bin
              !P.multi=[0,0,2]
              plot_spec,wave_array_shift,abs(specimage_fc_1d_smooth-cohen_flux_bin)/cohen_flux_bin*100., $ ; systematic error
                        color=!IRC_SPECRED_COLOR.white,psym=10,ytitle='fractional error (%)',yr=[0,50], $
                        xrange=x_range_set, $
                        clip_range=clip_range,space_shift=space_shift,nsum=nsum
              plot_spec,wave_array_shift,error_p_fc_total/cohen_flux_bin*100., $
                        psym=10,color=!IRC_SPECRED_COLOR.red,/oplot,clip_range=clip_range,space_shift=space_shift,nsum=nsum ; S/N plot
              
              plot_spec_obs,wave_array_shift,specimage_fc_1d_smooth,error_p_fc_total,error_n_fc_total,d_wave_array, $
                            redshift=redshift,mjy=mjy,watt=watt,lambda2=lambda2, $
                            _extra=extra_keywords,oplot=oplot,clip_range=clip_range,space_shift=space_shift,nsum=nsum
              plot_spec_cohen,cohen_lambda,cohen_flux,cohen_d_flux,wave_array_shift, $
                              with_image=with_image,mJy=mjy,watt=watt,lambda2=lambda2, $
                              _extra=extra_keywords,clip_range=clip_range,space_shift=space_shift,nsum=nsum
              
              !P.multi=0
           endif else begin
              plot_spec_obs,wave_array_shift,specimage_fc_1d_smooth,error_p_fc_total,error_n_fc_total,d_wave_array, $
                            redshift=redshift,mjy=mjy,watt=watt,diffuse=diffuse,lambda2=lambda2, $
                            _extra=extra_keywords,with_image=with_image,oplot=oplot,clip_range=clip_range, $
                            space_shift=space_shift,nsum=nsum
              plot_spec_cohen,cohen_lambda,cohen_flux,cohen_d_flux,wave_array_shift, $
                              with_image=with_image,mJy=mjy,watt=watt,diffuse=diffuse,lambda2=lambda2, $
                              _extra=extra_keywords,clip_range=clip_range,space_shift=space_shift,nsum=nsum
           endelse
           
        endelse
        
; overplot template spectra
        if keyword_set(lambda_template) then begin
           redshift_spec,lambda_template,flux_template,z_template,scale_template,lambda_template_z,flux_template_z
           plot_spec,lambda_template_z,flux_template_z,color=!IRC_SPECRED_COLOR.blue,/oplot, $
                     mjy=mjy,watt=watt,diffuse=diffuse,lambda2=lambda2, $
                     clip_range=clip_range,space_shift=space_shift,nsum=nsum, $
                     x_range=x_range_set
;          oplot,lambda_template,flux_template,color=!IRC_SPECRED_COLOR.blue,psym=10
        endif
        
; plot background spectrum
        if keyword_set(bg_show) then begin
           plot_spec,wave_array_shift,off_specimage_fc_1d_smooth, $
                     color=!IRC_SPECRED_COLOR.green,psym=10,/oplot,mjy=mjy,watt=watt,diffuse=diffuse,lambda2=lambda2, $
                     clip_range=clip_range, $
                     xstyle=5,ystyle=5, $ ; suppress plot boxes
                     xrange=x_range_set, $
                     space_shift=space_shift,nsum=nsum,_extra=extra_keywords

;          plot_spec,wave_array_shift,off_specimage_fc_1d_smooth,color=!IRC_SPECRED_COLOR.red
        endif
     end
  endcase
  
  if ~ defined(no_reliable_range) then begin
; plot X range for reliable range
     if (!Y.range[0] EQ 0D && !Y.range[1] EQ 0D) then begin
        tmp=where(specimage_fc_1d_smooth GT 0.,count)
        if count GT 0 then y_vertical_range_min=min(specimage_fc_1d[tmp])*1000. $
        else               y_vertical_range_min=min(specimage_fc_1d_smooth)*1000.
        y_vertical_range=[y_vertical_range_min,max(specimage_fc_1d_smooth*1000.)]
     endif else $
        Y_vertical_range=!Y.RANGE
     
     y_vertical_range=[-1e6,1e6]
     
     oplot,[!IRC_SPECRED_SPECPARAM.w_cover[0],!IRC_SPECRED_SPECPARAM.w_cover[0]],Y_vertical_range, $ ; was w_cover_2
           color=!IRC_SPECRED_COLOR.green,_extra=extra_keywords
     oplot,[!IRC_SPECRED_SPECPARAM.w_cover[1],!IRC_SPECRED_SPECPARAM.w_cover[1]],Y_vertical_range, $ ; was w_cover_2
           color=!IRC_SPECRED_COLOR.green,_extra=extra_keywords ; was [-1e6,1e6]
;  if keyword_set(wc_mode) && NP() then begin
;     oplot,[2.4,2.4],[-1e6,1e6], $
;           color=!IRC_SPECRED_COLOR.green,_extra=extra_keywords ; was [-1e6,1e6]
;  endif
  endif

; display image nicely
     x_range_org=!x.crange
     y_range_org=!y.crange

  if keyword_set(with_image) then begin
     !p.position=[margin,0.5*margin,1.0-margin,0.5*(1.0-margin)] ; set the draw area to be lower half
     draw_tv,specimage_n_wc_med,specmask_n_work,wave_array_shift,source_id, $
             tvtop=tvtop,tvbottom=tvbottom,margin=margin,x_winsize=x_winsize,y_winsize=y_winsize,ps=ps, $
             bg_sub=bg_sub,bg_nsum=bg_nsum,bg_offset=bg_offset,bg_show=bg_show,bg_oneside=bg_oneside, $
             space_shift=space_shift,nsum=nsum,space_smooth=space_smooth
  endif else begin
     !p.position=0
  endelse

; output ASCII dump file
  
  if keyword_set(ASCII) then begin
     print,'Writing an ASCII spectrum.'
     if defined(dir) then dir=expand_path(dir) else dir=!IRC_SPECRED_DIR.workdir

     if keyword_set(noise_plot_only) then $
        write_spec,wave_array_shift,error_p_fc_total*noise_fac, $
                   filename=dir+'/'+ASCII+'.spc',watt=watt,mjy=mjy,lambda2=lambda2, $
                   redshift=redshift,space_shift=space_shift,nsum=nsum $
     else $
        write_spec, $
        wave_array_shift,specimage_fc_1d_smooth, $
        specimage_fc_1d_smooth-error_n_fc_total, $
        specimage_fc_1d_smooth+error_p_fc_total, $
        filename=dir+'/'+ASCII+'.spc', $
        watt=watt,mjy=mjy,lambda2=lambda2,redshift=redshift,diffuse=diffuse,space_shift=space_shift,nsum=nsum
; to plot the output with the gnuplot, type 'plot "ASCII.spc" with yerrorbars'
  endif
  
  if defined(PS) then psoff
  
  if keyword_set(PNG) then begin
     print,'Writing a PNG file.'
     saveimage,!IRC_SPECRED_DIR.workdir+'/'+PNG+'_TEMPFIT.png',/png
  endif
  
; !p.position=0
  
;  specmask_n=specmask_n_org

; !x.range=x_range_org
; !y.range=y_range_org
;  !X.range=0 & !Y.range=0


end
