pro show_aperture_on_ds9,image,source_table, $
                         IMAG=IMAG,median=median,sigma_filter_set=sigma_filter_set, $
                         header=header,space_shift=space_shift,nsum=nsum 

  set_ds9_title,'IRC_SPECRED',ds9_title

; Check if ds9 is already up...
  spawn,'xpaaccess -n '+ds9_title,result

; if ds9 is not ready, launch the new one.
  if fix(result) EQ 0 then spawn,'ds9 -title '+ds9_title+' -scale mode zscale -tile yes &'

; wait till ds9 is up and ready
  repeat begin
     wait,1
     spawn,'xpaaccess -n '+ds9_title,result
  endrep until fix(result) EQ 1

  spawn,'xpaset -p '+ds9_title+' regions format ds9'

; re-set DS9 frame size nicely.
  s=size(image) & dim=s[0]
  if NIR() then fac=1 else fac=2
  spawn,'xpaget '+ds9_title+' height',result
  if float(result[0]) NE s[2]*fac then begin
     spawn,'xpaset -p '+ds9_title+' height '+strcompress(string(s[2]*fac)  ,/remove) + $
         '; xpaset -p '+ds9_title+' width ' +strcompress(string(s[1]*fac*2),/remove)
  endif
  
  if ~ file_test(!IRC_SPECRED_DIR.tmpdir,/directory) then file_mkdir,!IRC_SPECRED_DIR.tmpdir
  filename=!IRC_SPECRED_DIR.tmpdir+'/show_aperture_on_ds9_tmp.fits'
  file_delete,filename,/allow_nonexistent

  case 1 of
     (keyword_set(IMAG) && NIR()): mwrfits,sigma_filter_cube(image,2),filename,header,/silent
     (keyword_set(median)): mwrfits,medcube(image,2),filename,header,/silent
     (keyword_set(sigma_filter_set)): mwrfits,sigma_filter_cube(image,1),filename,header,/silent
     (keyword_set(IMAG) && LG2()): mwrfits,image,filename,header,/silent ; was medcube(,2)
     else: mwrfits,image,filename,header,/silent
  endcase

; display image on 2nd frame
  if keyword_set(IMAG) then begin
; check # of frames
     spawn,'xpaget '+ds9_title+' frame active',result
; when only 1 frame is active, launch the 2nd one.
     if strlen(result) EQ 2 then spawn,'xpaset -p '+ds9_title+' frame new'
     spawn,'xpaset -p '+ds9_title+' frame 2' 
  endif else spawn,'xpaset -p '+ds9_title+' frame 1'

  if NIR() then spawn,'xpaset -p '+ds9_title+' zoom to 1' $
  else          spawn,'xpaset -p '+ds9_title+' zoom to 2'

  spawn,'xpaset -p '+ds9_title+' file '+filename

  if dim EQ 3 then begin
     if !IRC_SPECRED_PROCESSOPTION.use_short_refimage_mode then $
        spawn,'xpaset -p '+ds9_title+' datacube 1' $ ; set datacube for long
     else $
        spawn,'xpaset -p '+ds9_title+' datacube 2' ; set datacube for long
  endif

  if defined(source_table) && n_elements(source_table) NE 0 then begin
     regionfilename=!IRC_SPECRED_DIR.tmpdir+'/show_aperture_on_ds9_tmp.reg'
     file_delete,regionfilename,/allow_nonexistent
     if keyword_set(IMAG) then $
        write_ds9_region_file,source_table,filename=regionfilename,/IMAG,space_shift=space_shift,nsum=nsum $
     else $
        write_ds9_region_file,source_table,filename=regionfilename,space_shift=space_shift,nsum=nsum
     spawn,'xpaset -p '+ds9_title+' regions load '+regionfilename
  endif
  
end
