;; 2009/02/11 T.WADA
;;   Subject: Re: pipelines for public release
;;   From: Youichi Ohyama <ohyama@ir.isas.jaxa.jp>
;;   Date: Thu, 22 Jan 2009 14:45:39 +0800
;;   
;; modified on 20080612: Y.Ohyama
pro calc_image_shift,inimage,dx,dy,IMAG=IMAG,short=short

  common GUI,logger

  if defined(logger) then logger->append,['  measuring offsets among subframes.']

  s=size(inimage) & xsize=s[1] & ysize=s[2]
  if s[0] EQ 2 then n_frame=1 else n_frame=s[3]
  dx=fltarr(n_frame) & dy=fltarr(n_frame)
  
  dx[0]=0. & dy[0]=0.           ; set initial
  
  if keyword_set(IMAG) && MIRS() then begin
     calc_mir_refimage_shift,inimage,n_frame,dx,dy
     goto,calc_finish
  endif
  
  i=0
  inimage_cut=inimage[!IRC_SPECRED_AREAINFO.cor_x1:!IRC_SPECRED_AREAINFO.cor_x2, $
                      !IRC_SPECRED_AREAINFO.cor_y1:!IRC_SPECRED_AREAINFO.cor_y2,*]

; combine images to make a reference image for detecting cosmic rays
;  irc_imcombine_n,inimage,inimage,median_image,/no_shift,comb_mode='median'
;  median_image_cut=median_image[!IRC_SPECRED_AREAINFO.cor_x1:!IRC_SPECRED_AREAINFO.cor_x2, $
;                      !IRC_SPECRED_AREAINFO.cor_y1:!IRC_SPECRED_AREAINFO.cor_y2,*]

;  inimage_cut_filter=sigma_filter_cube(inimage_cut,2)
  
;  ; make cosmic-ray image
;  crimage=inimage_cut[*,*,i]-median_image_cut[*,*,1]-sigma_filter(inimage_cut[*,*,i]-median_image_cut[*,*,1],radius=5,/iterate,/all)

; and subtract the cosmic-ray image
; refimage=inimage_cut[*,*,i]-crimage

  refimage=sigma_filter(inimage_cut[*,*,i],radius=1,/all,/iter,n_sigma=5)

; refimage=inimage_cut_filter[*,*,0]

  noise_refimage=robust_sigma_mod(refimage)
  
  dith_x=fltarr(n_frame) & dith_y=fltarr(n_frame)
  if !IRC_SPECRED_OBSPARAM.AOT EQ '02B' then begin
     dith_x[1]=-8 & dith_y[1]=2
     if n_frame GT 2 then begin
        dith_x[2]=-13 & dith_y[2]=13
        if n_frame GT 3 then begin
           dith_x[3]=-4 & dith_y[3]=16
        endif
     endif
  endif
  
  x_cor_box_size=!IRC_SPECRED_COMBINEPARAM.x_cor_box_size
  y_cor_box_size=!IRC_SPECRED_COMBINEPARAM.y_cor_box_size

; widen the correlation peak search box size  
  if !IRC_SPECRED_OBSPARAM.AOT EQ '02B' then begin
     x_cor_box_size*=2.
     y_cor_box_size*=2.
  endif
  
; for the rest of the images
  for i=1,n_frame-1 do begin
                                ; check image
     tmp_inimage=total(inimage[*,*,i],/NAN)
     tmp_refimage=total(refimage[*,*],/NAN)
     
     if tmp_inimage EQ 0. || tmp_refimage EQ 0. then begin ; this is the flagged out one!
        dx[i]=dx[i-1] & dy[i]=dy[i-1] ; no correction!
        if defined(target_image) then refimage=target_image else continue
        continue
     endif

;    crimage=inimage_cut[*,*,i]- &
;    (median_image_cut[*,*,1]+sigma_filter(inimage_cut[*,*,i]-median_image_cut[*,*,1],radius=5,/iterate,/all))
;    target_image=inimage_cut_filter[*,*,i]
;    target_image=inimage_cut[*,*,i]-crimage

     target_image=sigma_filter(inimage_cut[*,*,i],radius=1,/all,/iter,n_sigma=5)

     target_image=shift(target_image,dith_x[i],dith_y[i])
     noise_target=robust_sigma_mod(target_image)
     
     retry_correlation:

     min_fac=!IRC_SPECRED_COMBINEPARAM.crosscor_min_fac
     max_fac=!IRC_SPECRED_COMBINEPARAM.crosscor_max_fac
     abs_max=!IRC_SPECRED_COMBINEPARAM.crosscor_abs_max
     
; modified on 20080612: for large noise_refimage, the min range (>) gets
; larger than the max range (<). So, I add '< abs_max/5 to
; ensure that min range should be always less than the max range.
      cor_image=correl_images_mod( $
                target_image>(min_fac*noise_refimage < abs_max/5.)< (max_fac*noise_refimage < abs_max), $
                    refimage>(min_fac*noise_refimage < abs_max/5.)< (max_fac*noise_refimage < abs_max), $
                xshift=x_cor_box_size,yshift=y_cor_box_size)
;     cor_image=correl_images_mod( $
;               target_image>(min_fac*noise_refimage)<(max_fac*noise_refimage < abs_max), $
;                   refimage>(min_fac*noise_refimage)<(max_fac*noise_refimage < abs_max), $
;               xshift=x_cor_box_size,yshift=y_cor_box_size)

; remove pseudo peak at the very center of the cor_image
     cor_image=sigma_filter(cor_image,radius=1,/iter,/all)
     
     s=size(cor_image) & xsize=s[1]
     offset=where(cor_image EQ max(cor_image)) & offset=offset[0] ; to make sure that offset is not a vector.
     offset_y=fix(offset/xsize) & offset_x=offset-offset_y*xsize
;  dx[i]=dx[i-1]+offset_x-x_cor_box_size
;  dy[i]=dy[i-1]+offset_y-y_cor_box_size
     
     result=mpfit2dpeak_nan(cor_image,A,/tilt,errmsg=errmsg,/positive,dof=dof,perror=perror,bestnorm=bestnorm)
     if defined(perror) then error=PERROR*SQRT(BESTNORM / DOF) else error=[100.,100.,0.,0.,0.,0.]

     dx[i]=dx[i-1]+A[4]-x_cor_box_size & dy[i]=dy[i-1]+A[5]-y_cor_box_size
;  dx[i]=        A[4]-x_cor_box_size & dy[i]=        A[5]-y_cor_box_size
;  print,'Information (calc_image_shift): difference between two method (X, Y) ',A[4]-offset_x[0],A[5]-offset_y[0]
     
     dx[i]-=dith_x[i]-dith_x[i-1] & dy[i]-=dith_y[i]-dith_y[i-1]

     if A[1] LT 0.6 then begin
        if keyword_set(short) then $
           print,'Warning (calc_image_shift): cross-correlation (short) peak is weak, '+strim(A[1])+ $
                 ', suggesting possible poor alignment between frame # of '+strim(i)+','+strim(i-1) $
        else $
           print,'Warning (calc_image_shift): cross-correlation (long) peak is weak, '+strim(A[1])+ $
                 ', suggesting possible poor alignment between frame # of '+strim(i)+','+strim(i-1)
     endif
     
     if error[4] GT 2. || error[5] GT 2. then $
        print,'Warning (calc_image_shift): cross-correlation image peak fitting error seems too large! '+ $
              strim(error[4])+' '+strim(error[5])
     if abs(A[4]-x_cor_box_size) GT 3. || abs(A[5]-y_cor_box_size) GT 3. then $
        print,'Warning (calc_image_shift): cross-correlation image shift seems too large! '+ $
              strim(A[4]-x_cor_box_size)+' '+strim(A[5]-y_cor_box_size)

;     if (offset_x EQ !IRC_SPECRED_AREAINFO.cor_x2-!IRC_SPECRED_AREAINFO.cor_x1-1 || offset_x EQ 0) || $
;        (offset_y EQ !IRC_SPECRED_AREAINFO.cor_y2-!IRC_SPECRED_AREAINFO.cor_y1-1 || offset_y EQ 0) then begin
     if (offset_x EQ 2*x_cor_box_size+1 || offset_x EQ 0) || $
        (offset_y EQ 2*y_cor_box_size+1 || offset_y EQ 0) then begin
        print,'Warning (calc_image_shift): Search box size is too small!'
        x_cor_box_size*=1.5 & y_cor_box_size*=1.5
        print,'Information (calc_image_shift): Retrying with wider correlation box.'
        goto,retry_correlation
     endif
     
     refimage=target_image & noise_refimage=noise_target

  endfor

calc_finish:
  
  if ~ keyword_set(IMAG) then begin ; the case of SPEC
     case !IRC_SPECRED_PROCESSTARGET.chip of
        0: begin
           if !IRC_SPECRED_OBSPARAM.AOT EQ '02B' then begin
              dx=dx-dx[0] & dy=dy-dy[0] ; for AOT02B operation
           endif else begin
              case !IRC_SPECRED_PROCESSTARGET.grism of
                 0: begin
                    dx=dx-dx[3] & dy=dy-dy[3]
                 end
                 1: begin 
                    if !IRC_SPECRED_OBSPARAM.AOT EQ '04C' then begin
                       dx=dx-dx[0] & dy=dy-dy[0] ; for AOT04C operation
                    endif else begin
                       dx=dx-dx[3] & dy=dy-dy[3] ; for A0T04B operation
                    endelse
                 end
              endcase
           endelse
        end
        1: begin
           case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin dx=dx-dx[10] & dy=dy-dy[10] & end
              1: begin 
                 if !IRC_SPECRED_OBSPARAM.AOT EQ '04A' || !IRC_SPECRED_OBSPARAM.AOT EQ '04B' then begin
                    dx_tmp=dx & dy_tmp=dy
                    dx_tmp-=dx_tmp[3] & dy_tmp-=dy_tmp[3]
                    dx_tmp=shift(dx_tmp,-4) & dy_tmp=shift(dy_tmp,-4)
                    dx_tmp=dx_tmp[0:3] & dy_tmp=dy_tmp[0:3]
                    dx=dx_tmp & dy=dy_tmp
                 endif else begin
                    dx=dx-dx[1] & dy=dy-dy[1]
                 endelse
              end
           endcase
        end
        2: begin
           case !IRC_SPECRED_PROCESSTARGET.grism of
           0: begin dx=dx-dx[10] & dy=dy-dy[10] & end
           1: begin dx=dx-dx[10] & dy=dy-dy[10] & end
           endcase
        end
     endcase

  endif else begin              ; IMAG
     case !IRC_SPECRED_PROCESSTARGET.chip of
        0: begin
           if !IRC_SPECRED_OBSPARAM.AOT EQ '02B' then begin
              dx=dx-dx[0] & dy=dy-dy[0]
           endif
        end
; do nothing, since NIR IMAG should have only one long (or short) image per AOT.
        1: begin
;          dx=dx-dx[1] & dy=dy-dy[1]
           dx-=mean(dx) & dy-=mean(dy)
        end
        2: begin 
           dx=dx-dx[1] & dy=dy-dy[1]
        end
     endcase
  endelse
  
end
