pro check_input_files,ext_source_table,refimage_list,specimage_list,darkimage_list

; source_table file
  if ext_source_table NE '' then begin
     ext_source_table=!IRC_SPECRED_DIR.datadir2+'/'+ext_source_table
     check_file,ext_source_table
  end
  
; FITS list file
  if defined(refimage_list) && defined(specimage_list) then begin
     refimage_list=!IRC_SPECRED_DIR.datadir2+'/'+refimage_list & specimage_list=!IRC_SPECRED_DIR.datadir2+'/'+specimage_list
     check_file,refimage_list
     check_file,specimage_list
  endif else begin
     if ~ defined(refimage_list) then begin
        refimage_list=DIALOG_PICKFILE(FILTER='*.lst',title='Input a REF_IMAG file list', $
                                      path=!IRC_SPECRED_DIR.workdir,get_path=!IRC_SPECRED_DIR.workdir)
        if refimage_list EQ '' then message,'Error (check_input_files): No reference image list was selected...Stop!'
     endif
     if ~ defined(specimage_list) then begin
        specimage_list=DIALOG_PICKFILE(FILTER='*.lst',title='Input a SPEC file list',path=!IRC_SPECRED_DIR.workdir)
        if specimage_list EQ '' then message,'Error (check_input_files): No spec image list was selected...Stop!'
     endif
  endelse
  
; DARK
  if NIR() then darkimage_list='DARK_NIR.lst' else darkimage_list='DARK_MIR.lst'
  darkimage_list=!IRC_SPECRED_DIR.datadir2+'/'+darkimage_list
  check_file,darkimage_list
  
end
