pro clean_flat_image,flat,flat_clean,sigma_fac=sigma_fac,interp=interp

  if ~ defined(sigma_fac) then sigma_fac=3.

  s=size(flat) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1

  flat_clean=flat

  if keyword_set(interp) then badvalue=0. else badvalue=!values.f_nan

  for i=0,n_frame-1 do begin
     flat_tmp=flat[*,*,i]
     flat_mask =make_array(size(flat_tmp,/dimension),/float,value=1.)
     flat_mask2=make_array(size(flat_tmp,/dimension),/float,value=1.)

     flat_tmp_filter=sigma_filter(flat_tmp,radius=1,/iter,/all)
     flat_tmp_filter_bg=flat_tmp-flat_tmp_filter
     flat_tmp_filter_bg-=median(flat_tmp_filter_bg)

     rms_flat_tmp_filter_bg=robust_sigma_mod(flat_tmp_filter_bg)
     flat_tmp_filter_bg=(abs(flat_tmp_filter_bg) $
                         > (sigma_fac*rms_flat_tmp_filter_bg))
;                        -sigma_fac*rms_flat_tmp_filter_bg

     bad_region=where((flat_tmp_filter_bg GT 0.20) OR (finite(flat_tmp,/NAN)),count)
     if count GT 0 then begin
        flat_mask[bad_region]=badvalue
        mask_grow,flat_mask,flat_mask_grow,grow_width=-1
     endif else flat_mask_grow=flat_mask

     bad_region=where((flat_tmp_filter_bg GT 0.03) OR (finite(flat_tmp,/NAN)),count2)
     if count2 GT 0 then begin
        flat_mask2[bad_region]=badvalue
     endif

     flat_clean_tmp=flat[*,*,i]*flat_mask_grow*flat_mask2

     if keyword_set(interp) then begin
        flat_clean_tmp_interp=maskinterp(flat_clean_tmp,flat_mask_grow*flat_mask2,1,6,"plsfit")
        flat_clean[*,*,i]=flat_clean_tmp_interp
     endif else begin
        flat_clean[*,*,i]=flat_clean_tmp
     endelse
  endfor

end

