pro coadd_irsspec,lambda,flux,d_flux,lambda_coadd_uniq,flux_coadd_uniq

  n=n_elements(lambda)
  lambda_coadd=fltarr(n)
  flux_coadd=fltarr(n)
  d_lambda=0.00001
  
  lambda_sort=lambda[sort(lambda)]
  flux_sort=flux[sort(lambda)]
  d_flux_sort=d_flux[sort(lambda)]
  
  for i=0,n-1 do begin
     lambda0=lambda_sort[i]
     same_lambda=where(lambda_sort GE lambda0-d_lambda AND lambda_sort LT lambda0+d_lambda, count)
;  if count GT 0 then flux0=mean(flux_sort[same_lambda]) else flux0=0.
;  print,i,lambda0,count,flux_sort[same_lambda],d_flux_sort[same_lambda]
     if count GT 0 then begin
        if finite(total(d_flux_sort[same_lambda])) then begin ; sometimes d_flux is NAN but flux is non_NAN.
           A=total((flux_sort/d_flux_sort)[same_lambda],/NAN) & B=total(1./d_flux_sort[same_lambda],/NAN)
           flux0=A/B
           flux0=w_mean(flux_sort[same_lambda],1./d_flux_sort[same_lambda])
        endif else begin
           flux0=mean(flux_sort[same_lambda])
        endelse
     endif else flux0=0.
     
     flux_coadd[i]=flux0
     lambda_coadd[i]=lambda0
  end
  
  sort_key=sort(lambda_coadd)
  uniq_key=uniq(lambda_coadd[sort_key])
  lambda_coadd_uniq=lambda_coadd[uniq_key]
  flux_coadd_uniq=flux_coadd[uniq_key]
  
end

; use writexy,lambda_coadd,flux_coadd for writing
