pro correct_columnpulldown_mask,specimage,refimage,specoutimage

  print,'Information (correct_columnpulldown_mask): Masks for pulled-down pixels are being applied.'

  sigma_fac=2.
  smooth_width=10

  s=size(specimage) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1
  xsize=s[1] & ysize=s[2]
  xarray=findgen(xsize)
  
  specoutimage=specimage
  
  for frame_id=0,n_frame-1 do begin
     specimage_work=specimage[0:50,*,frame_id]
     specimage_local=point_remover_mod(specimage_work,3,10)
     specimage_bg=specimage_local
     specimage_bg_1d=median(specimage_bg[*,*],dimension=1)
     specimage_bg_1d_smooth=median(specimage_bg_1d,smooth_width)
     specimage_bg_1d_local=specimage_bg_1d-specimage_bg_1d_smooth

     noise=sigma(specimage_bg_1d_local)
     pullpos=where(specimage_bg_1d_local LT -sigma_fac*noise, count)
     if count GT 0 then begin
        for line=0,count-1 do begin
           pull=specimage_bg_1d[pullpos[line]]
           specoutimage[*,pullpos[line],frame_id]=!values.f_nan
           if frame_id LT n_frame-1 then specoutimage[*,pullpos[line],frame_id+1]=!values.f_nan
                                ; mask also next frame
        endfor
     endif
  endfor

; In addition, mask 5th frame based on reference image pull-down information
  specimage_work=refimage[0:50,*]
  specimage_local=point_remover_mod(specimage_work,3,10)
  specimage_bg=specimage_local
  specimage_bg_1d=median(specimage_bg[*,*],dimension=1)
  specimage_bg_1d_smooth=median(specimage_bg_1d,smooth_width)
  specimage_bg_1d_local=specimage_bg_1d-specimage_bg_1d_smooth
  
  noise=sigma(specimage_bg_1d_local)
  pullpos=where(specimage_bg_1d_local LT -sigma_fac*noise, count)
  if count GT 0 then begin
     for line=0,count-1 do begin
        pull=specimage_bg_1d[pullpos[line]]
        specoutimage[*,pullpos[line],4]=!values.f_nan
     endfor
  endif

end
