pro correct_mir_columnpulldown,inimage,outimage,mask=mask,dx=dx,dy=dy

  clip_sigma=1.5

  s=size(inimage) & if s[0] EQ 3 then n_frame=s[3] else n_frame=1
  xsize=s[1] & ysize=s[2]
 
  if ~ defined(dx) then dx=fltarr(n_frame)
  if ~ defined(dy) then dy=fltarr(n_frame)

  if n_elements(dx) LT n_frame then begin
     dx2=fltarr(n_frame)
     dx2[0:n_elements(dx)-1]=dx
     dx=dx2
  endif
 
 if n_elements(dy) LT n_frame then begin
     dy2=fltarr(n_frame)
     dy2[0:n_elements(dy)-1]=dy
     dy=dy2
  endif

  outimage=inimage
  
  for frame_id=0,n_frame-1 do begin
     outimage_tmp=inimage[*,*,frame_id]
     outimage_tmp2=outimage_tmp
     if defined(mask) then outimage_tmp2*=shift(mask,dx[frame_id],dy[frame_id])
;     irc_mmm,outimage_tmp2,skymod,sigma_value,skew
;     if sigma_value LT 0. then skymod=median(outimage_tmp)
     sigma_value=robust_sigma_mod(outimage_tmp2)
     skymod=median(outimage_tmp2)

     sky_reject=where((outimage_tmp2 GT skymod+clip_sigma*sigma_value OR outimage_tmp2 LT skymod-clip_sigma*sigma_value) OR (finite(outimage_tmp2,/NAN)) ,count)
     if count GT 0 then outimage_tmp2[sky_reject]=!values.f_nan
     outimage_tmp_1d=median(outimage_tmp2[*,*],dimension=2)
     for y=0,ysize-1 do outimage_tmp[*,y]-=outimage_tmp_1d
     outimage[*,*,frame_id]=outimage_tmp
  endfor

;if !IRC_SPECRED_MISC.first_pass EQ 0B then message,'Finish'

end
