pro display_extracted_images,targetid,targetsubid,ext_source_table,refimage_n_filename,specimage_n_filename,filter_spec, $
                             root_dir=root_dir,space_shift=space_shift,nsum=nsum
  
;  common measured_offsets,space_shift,nsum
  
  make_env_var                  ; make environment variables
  do_param_initialize,filter_spec,targetid,targetsubid, $
                      root_dir=root_dir,/no_logger_init,reference_fits=refimage_n_filename,/file_in_workdir
  
  read_source_table,source_table,ext_source_table=!IRC_SPECRED_DIR.workdir+'/'+ext_source_table
  
; read fits
  refimage_n= MRDFITS(!IRC_SPECRED_DIR.workdir+'/'+refimage_n_filename, 0, imagheader, /silent)
  specimage_n= MRDFITS(!IRC_SPECRED_DIR.workdir+'/'+specimage_n_filename, 0, specheader, /silent)
  
  !IRC_SPECRED_SPECPARAM.wave_offset_pix=float(fxpar(specheader,'W_OFFSET'))
  
; display extracted spectra on ds9
  refimage_n_bg= MRDFITS(!IRC_SPECRED_DIR.workdir+'/'+refimage_n_filename, 0, imagheader, /silent)
  specimage_n_bg= MRDFITS(!IRC_SPECRED_DIR.workdir+'/'+specimage_n_filename, 0, imagheader, /silent)
  
  irc_show_aperture_n_on_ds9,source_table,refimage_n,specimage_n,space_shift=space_shift,nsum=nsum
  
; Example
; display_extracted_images,5020033,1,'5020033.1.N3_NP.source_table.tbl','5020033.1.N3_NP.refimage_bg_indiv.fits','5020033.1.N3_NP.specimage_wc_indiv.fits','N3_NP',root_dir='~/hd1.cava/IRC/PV/SPEC/FLUX/'
  
end
