function bin_array,array,bin_size

  binned_array=array
  k=0

  for i=0,n_elements(array)-1-bin_size,bin_size do begin
     binned_array[k]=median(array[i:i+bin_size-1],/even)
     k+=1
  endfor

  binned_array=binned_array[0:k-1]

  return,binned_array

end

pro do_bin_spec_for_plot, $
   specimage_fc_1d,off_specimage_fc_1d,specimage_wc_1d,off_specimage_wc_1d,source_id, $
   specimage_wc_1d_smooth,specimage_fc_1d_smooth,off_specimage_fc_1d_smooth,off_specimage_wc_1d_smooth, $
   error_n_wc_total,error_p_wc_total,error_n_fc_total,error_p_fc_total,error_n_wc_total_bg,error_p_wc_total_bg, $
   smooth_fac=smooth_fac,bg_sub=bg_sub,wave_array_org=wave_array_org,wave_array_bin=wave_array_bin
  
; if ~ defined(smooth_width) then smooth_width_tmp=1 else smooth_width_tmp=smooth_width; width=1 means no smoothing.
  if ~ defined(smooth_fac) then smooth_fac_tmp=1 else smooth_fac_tmp=smooth_fac; width=1 means no median smoothing.

  if ~ defined(!IRC_SPECRED_PLOTPARAM.smooth) then $
     smooth_width_tmp=1 $
  else $
     smooth_width_tmp=!IRC_SPECRED_PLOTPARAM.smooth
  
; smooth_width_tmp: smooth box length along wavelnegth direction
; smooth_fac: extra smoothing factor, due to smoothing on 2D

  if smooth_width_tmp EQ 0 then smooth_width_tmp=1 ; width=1 means no smoothing.

  if smooth_width_tmp GT 1 then begin

     wave_array_bin=bin_array(wave_array_org,smooth_width_tmp)

     masked_region=where(finite(off_specimage_fc_1d[*,source_id],/NAN),count)
     off_specimage_fc_1d_smooth=bin_array(off_specimage_fc_1d[*,source_id],smooth_width_tmp)
     if count GT 0 then off_specimage_fc_1d_smooth[masked_region]=!values.f_nan
     masked_region=where(finite(off_specimage_wc_1d[*,source_id],/NAN),count)
     off_specimage_wc_1d_smooth=bin_array(off_specimage_wc_1d[*,source_id],smooth_width_tmp)
     if count GT 0 then off_specimage_wc_1d_smooth[masked_region]=!values.f_nan

     error_n_fc_total=bin_array(error_n_fc_total,smooth_width_tmp)
     error_p_fc_total=bin_array(error_p_fc_total,smooth_width_tmp)

     if keyword_set(bg_sub) then begin
        masked_region=where(finite(specimage_fc_1d[*,source_id]-off_specimage_fc_1d[*,source_id],/NAN),count)
        specimage_fc_1d_smooth=bin_array(specimage_fc_1d[*,source_id]-off_specimage_fc_1d[*,source_id],smooth_width_tmp)
        if count GT 0 then specimage_fc_1d_smooth[masked_region]=!values.f_nan
        masked_region=where(finite(specimage_wc_1d[*,source_id]-off_specimage_wc_1d[*,source_id],/NAN),count)
        specimage_wc_1d_smooth=bin_array(specimage_wc_1d[*,source_id]-off_specimage_wc_1d[*,source_id],smooth_width_tmp)
        if count GT 0 then specimage_wc_1d_smooth[masked_region]=!values.f_nan
     endif else begin
        masked_region=where(finite(specimage_fc_1d[*,source_id],/NAN),count)
        specimage_fc_1d_smooth=bin_array(specimage_fc_1d[*,source_id],smooth_width_tmp)
        if count GT 0 then specimage_fc_1d_smooth[masked_region]=!values.f_nan
        masked_region=where(finite(specimage_wc_1d[*,source_id],/NAN),count)
        specimage_wc_1d_smooth=bin_array(specimage_wc_1d[*,source_id],smooth_width_tmp)
        if count GT 0 then specimage_wc_1d_smooth[masked_region]=!values.f_nan
     endelse
     
;   robust_boxcar,wave_array_shift,specimage_fc_1d[*,source_id],smooth_width,wave_array_shift_smooth,specimage_fc_1d_smooth
;   specimage_fc_1d_smooth*=1000.
     
;   robust_boxcar,wave_array_shift,error_n_fc_total,smooth_width,wave_array_shift_smooth,error_n_fc_total_smooth
;   robust_boxcar,wave_array_shift,error_p_fc_total,smooth_width,wave_array_shift_smooth,error_p_fc_total_smooth

  endif else begin

     wave_array_bin=wave_array_org

     off_specimage_fc_1d_smooth=off_specimage_fc_1d[*,source_id]
     off_specimage_wc_1d_smooth=off_specimage_wc_1d[*,source_id]
     if keyword_set(bg_sub) then begin
        specimage_fc_1d_smooth=specimage_fc_1d[*,source_id]-off_specimage_fc_1d[*,source_id]
        specimage_wc_1d_smooth=specimage_wc_1d[*,source_id]-off_specimage_wc_1d[*,source_id]
     endif else begin
        specimage_fc_1d_smooth=specimage_fc_1d[*,source_id]
        specimage_wc_1d_smooth=specimage_wc_1d[*,source_id]
     endelse

;    wave_array_shift_smooth=wave_array_shift
;    error_n_fc_total_smooth=error_n_fc_total
;    error_p_fc_total_smooth=error_p_fc_total
  endelse

; reducing error signal according to smooth length
  error_n_fc_total/=(sqrt(smooth_width_tmp*smooth_fac_tmp))    & error_p_fc_total/=(sqrt(smooth_width_tmp*smooth_fac_tmp))
  error_n_wc_total/=(sqrt(smooth_width_tmp*smooth_fac_tmp))    & error_p_wc_total/=(sqrt(smooth_width_tmp*smooth_fac))
  error_n_wc_total_bg/=(sqrt(smooth_width_tmp*smooth_fac_tmp)) & error_p_wc_total_bg/=(sqrt(smooth_width_tmp*smooth_fac_tmp))
  
;  remove_edge,specimage_wc_1d_smooth
;  remove_edge,specimage_fc_1d_smooth
;  remove_edge,off_specimage_fc_1d_smooth
;  remove_edge,off_specimage_wc_1d_smooth
;remove_edge,error_n_wc_total
;remove_edge,error_p_wc_total
;remove_edge,error_n_fc_total
;remove_edge,error_p_fc_total
;remove_edge,error_n_wc_total_bg
;remove_edge,error_p_wc_total_bg

end
