pro remove_edge,spec

  s=size(spec) & n_spec=s[1]
  
  spec[0:!IRC_SPECRED_PLOTPARAM.smooth-1,*]=!values.f_nan
  spec[n_spec-2-!IRC_SPECRED_PLOTPARAM.smooth:n_spec-1,*]=!values.f_nan

end

pro do_smooth_spec_for_plot, $
   specimage_fc_1d,off_specimage_fc_1d,specimage_wc_1d,off_specimage_wc_1d,source_id, $
   specimage_wc_1d_smooth,specimage_fc_1d_smooth,off_specimage_fc_1d_smooth,off_specimage_wc_1d_smooth, $
   error_n_wc_total,error_p_wc_total,error_n_fc_total,error_p_fc_total,error_n_wc_total_bg,error_p_wc_total_bg, $
   smooth_fac=smooth_fac,bg_sub=bg_sub
  
; if ~ defined(smooth_width) then smooth_width_tmp=1 else smooth_width_tmp=smooth_width; width=1 means no smoothing.
  if ~ defined(smooth_fac) then smooth_fac_tmp=1 else smooth_fac_tmp=smooth_fac; width=1 means no median smoothing.

  if ~ defined(!IRC_SPECRED_PLOTPARAM.smooth) then $
     smooth_width_tmp=1 $
  else $
     smooth_width_tmp=!IRC_SPECRED_PLOTPARAM.smooth
  
; smooth_width_tmp: smooth box length along wavelnegth direction
; smooth_fac: extra smoothing factor, due to smoothing on 2D


  if smooth_width_tmp EQ 0 then smooth_width_tmp=1 ; width=1 means no smoothing.

  if smooth_width_tmp GT 1 then begin
     masked_region=where(finite(off_specimage_fc_1d[*,source_id],/NAN),count)
     off_specimage_fc_1d_smooth=smooth(off_specimage_fc_1d[*,source_id],smooth_width_tmp)
     if count GT 0 then off_specimage_fc_1d_smooth[masked_region]=!values.f_nan
     masked_region=where(finite(off_specimage_wc_1d[*,source_id],/NAN),count)
     off_specimage_wc_1d_smooth=smooth(off_specimage_wc_1d[*,source_id],smooth_width_tmp)
     if count GT 0 then off_specimage_wc_1d_smooth[masked_region]=!values.f_nan

     if keyword_set(bg_sub) then begin
        masked_region=where(finite(specimage_fc_1d[*,source_id]-off_specimage_fc_1d[*,source_id],/NAN),count)
        specimage_fc_1d_smooth=smooth(specimage_fc_1d[*,source_id]-off_specimage_fc_1d[*,source_id],smooth_width_tmp)
        if count GT 0 then specimage_fc_1d_smooth[masked_region]=!values.f_nan
        masked_region=where(finite(specimage_wc_1d[*,source_id]-off_specimage_wc_1d[*,source_id],/NAN),count)
        specimage_wc_1d_smooth=smooth(specimage_wc_1d[*,source_id]-off_specimage_wc_1d[*,source_id],smooth_width_tmp)
        if count GT 0 then specimage_wc_1d_smooth[masked_region]=!values.f_nan
     endif else begin
        masked_region=where(finite(specimage_fc_1d[*,source_id],/NAN),count)
        specimage_fc_1d_smooth=smooth(specimage_fc_1d[*,source_id],smooth_width_tmp)
        if count GT 0 then specimage_fc_1d_smooth[masked_region]=!values.f_nan
        masked_region=where(finite(specimage_wc_1d[*,source_id],/NAN),count)
        specimage_wc_1d_smooth=smooth(specimage_wc_1d[*,source_id],smooth_width_tmp)
        if count GT 0 then specimage_wc_1d_smooth[masked_region]=!values.f_nan
     endelse
     
;   robust_boxcar,wave_array_shift,specimage_fc_1d[*,source_id],smooth_width,wave_array_shift_smooth,specimage_fc_1d_smooth
;   specimage_fc_1d_smooth*=1000.
     
;   robust_boxcar,wave_array_shift,error_n_fc_total,smooth_width,wave_array_shift_smooth,error_n_fc_total_smooth
;   robust_boxcar,wave_array_shift,error_p_fc_total,smooth_width,wave_array_shift_smooth,error_p_fc_total_smooth

  endif else begin
     off_specimage_fc_1d_smooth=off_specimage_fc_1d[*,source_id]
     off_specimage_wc_1d_smooth=off_specimage_wc_1d[*,source_id]
     if keyword_set(bg_sub) then begin
        specimage_fc_1d_smooth=specimage_fc_1d[*,source_id]-off_specimage_fc_1d[*,source_id]
        specimage_wc_1d_smooth=specimage_wc_1d[*,source_id]-off_specimage_wc_1d[*,source_id]
     endif else begin
        specimage_fc_1d_smooth=specimage_fc_1d[*,source_id]
        specimage_wc_1d_smooth=specimage_wc_1d[*,source_id]
     endelse

;    wave_array_shift_smooth=wave_array_shift
;    error_n_fc_total_smooth=error_n_fc_total
;    error_p_fc_total_smooth=error_p_fc_total
  endelse

; reducing error signal according to smooth length
  error_n_fc_total/=(sqrt(smooth_width_tmp*smooth_fac_tmp))    & error_p_fc_total/=(sqrt(smooth_width_tmp*smooth_fac_tmp))
  error_n_wc_total/=(sqrt(smooth_width_tmp*smooth_fac_tmp))    & error_p_wc_total/=(sqrt(smooth_width_tmp*smooth_fac))
  error_n_wc_total_bg/=(sqrt(smooth_width_tmp*smooth_fac_tmp)) & error_p_wc_total_bg/=(sqrt(smooth_width_tmp*smooth_fac_tmp))
  

  remove_edge,specimage_wc_1d_smooth
  remove_edge,specimage_fc_1d_smooth
  remove_edge,off_specimage_fc_1d_smooth
  remove_edge,off_specimage_wc_1d_smooth
;remove_edge,error_n_wc_total
;remove_edge,error_p_wc_total
;remove_edge,error_n_fc_total
;remove_edge,error_p_fc_total
;remove_edge,error_n_wc_total_bg
;remove_edge,error_p_wc_total_bg

end
