pro ds9_make_fits_files,image3d,specimage3d,no_refimage=no_refimage

  s=size(specimage3d) & if s[0] EQ 2 then n_source=1 else n_source=s[3]
 
  if ~ file_test(!IRC_SPECRED_DIR.tmpdir,/directory) then file_mkdir,!IRC_SPECRED_DIR.tmpdir

  for source_id=0,n_source-1 do begin
     if ~ keyword_set(no_refimage) then begin
        if n_source GT 1 then begin ; the case of 3D image
           image3d_bg=image3d[*,*,source_id]
           specimage3d_bg=specimage3d[*,*,source_id]
        endif else begin        ; the case of 2D
           image3d_bg=image3d[*,*]
           specimage3d_bg=specimage3d[*,*]
        endelse
        disp_image=[[image3d_bg/10.],[specimage3d_bg]]
     endif else begin
        disp_image=specimage3d[*,*,source_id]
     endelse
     
     filename=strcompress(!IRC_SPECRED_DIR.tmpdir+'/tmp.'+string(source_id)+'.fits',/remove_all)
     file_delete,filename,/allow_nonexistent
     mwrfits,disp_image,filename,/silent
  endfor
  
end
