pro ds9_make_region_files,source_table,dx,dy,use_array,regionfilename0=regionfilename0

  n_source=n_elements(source_table)

  get_valid_y_range,cut_in,cut_out
  dy_specbox=abs(cut_out-cut_in)
  specbox_offset=-((source_table[0].spec_mask_dy)/2.-(dy_specbox/2.+cut_in))
  
  for frame=1,n_source do begin ; frame counts from one, not zero! in ds9.
     regionfilename=strcompress(regionfilename0+string(frame)+'.reg',/remove_all)
     file_delete,regionfilename,/allow_nonexistent
     select=where(frame EQ use_array,selected)
     if selected GT 0 then begin ; make a region file only if active
        GET_LUN,U & openw,U,regionfilename
        i=frame-1               ;make the target region comes at first
        printf,U, $
               source_table[i].image_x-source_table[frame-1].image_x+dx+1., $
;              source_table[i].image_y-source_table[frame-1].image_y+dy+1., $
               source_table[i].image_y-source_table[frame-1].image_y+dy+1.+specbox_offset, $
               source_table[i].spec_mask_dx, $
;              source_table[i].spec_mask_dy, $
               dy_specbox, $
               0,i,$
               format='("image;box(",I5,",",I5,",",I5,",",I5,",",I5,") # color=red text={",I5,"}")'

        for source_id=0,n_source-1 do begin
           if source_id NE frame-1 then begin
              select2=where(source_id EQ use_array-1,selected2)
              if selected2 GT 0 then begin ; make a region file only if active
                 printf,U,$
                        source_table[source_id].image_x-source_table[frame-1].image_x+dx+1., $
;                       source_table[source_id].image_y-source_table[frame-1].image_y+dy+1., $
                        source_table[source_id].image_y-source_table[frame-1].image_y+dy+1.+specbox_offset, $
                        source_table[source_id].spec_mask_dx, $
;                        source_table[source_id].spec_mask_dy, $
                        dy_specbox, $
                        0,source_id,$
                        format='("image;box(",I5,",",I5,",",I5,",",I5,",",I5,") # color=green text={",I5,"}")'
; add (+1,+1) for FITS viewer whose origin is at (1,1), not at (0,0)
                 zero_pos_x=source_table[source_id].spec_x-source_table[frame-1].spec_x+dx+1.+!IRC_SPECRED_SPECEXTRACTPARAM.x_zero_offset;+space_shift
                 zero_pos_y=source_table[source_id].spec_y-source_table[frame-1].spec_y+dy+1.+!IRC_SPECRED_SPECEXTRACTPARAM.y_zero_offset
                 radius=(source_table[source_id].image_FWHM/2.) > 1.

                 if finite(!IRC_SPECRED_SPECPARAM.wave_offset_pix) then begin
                    if LG2() then $
                       zero_pos_y-=!IRC_SPECRED_SPECPARAM.wave_offset_pix $
                    else $
                       zero_pos_y-=!IRC_SPECRED_SPECPARAM.wave_offset_pix ; was plus for LG2
                 endif
                 printf,U,zero_pos_x,zero_pos_y,radius,source_id,$
                        format='("image;circle(",F8.3,",",F8.3,",",F8.3,") # color=yellow text={",I5,"}")'

              endif else begin
                 printf,U,format='(" ")' 
              endelse
           endif
        endfor
        close,U & FREE_LUN,U
     endif
     
  endfor                        ; of frame loop
end
