pro ds9_region_read,source_table,dx,dy,use_array,title=title

; direct region read through xpa
  n_source=n_elements(source_table)
  region=intarr(5,n_source)     ; 5 = n_elements(x,y,dx,dy,angle)
  
  for frame=1,n_source do begin
     select=where(frame EQ use_array,selected)
     if selected GT 0 then begin ; make a region file only if active
        spawn,'xpaset -p '+title+' frame '+string(frame)+';xpaget '+title+' regions',result
        region[*,frame-1]=strsplit(strmid(result[0],15,100),' ',/extract)
     endif
  end
; No. 1 frame is the only one we need = the aperture for the selected one.
  
;source_table.spec_x      =reform(float(region[0,*]),n_source)-dx-1+source_table.spec_x
;source_table.spec_y      =reform(float(region[1,*]),n_source)-dy-1+source_table.spec_y
  source_table.spec_mask_dx=reform(float(region[2,*]),n_source)
  source_table.spec_mask_dy=reform(float(region[3,*]),n_source)

end
