pro irc_darty_photometry,image,x,y,flux,use_array

  s=size(image) & xsize=s[1] & ysize=s[2]
  xr=round(x) & yr=round(y)
  n_source=n_elements(x)

  box_half_size_for_aper0=!IRC_SPECRED_CHIPINFO.APPHOTORAD+4+2 ; was 4
  
  for source_id=0,n_source-1 do begin
     if xr[source_id] LE 0 || xr[source_id] GE xsize-1 || yr[source_id] LE 0 || yr[source_id] GE ysize-1 then begin
        flux[source_id]=!values.f_nan
        continue
     endif

     tmp=where(use_array EQ source_id, count)
     if count GT 0 then begin
        box_half_size_x_for_aper=min([xsize-x[source_id],box_half_size_for_aper0,x[source_id]-0])
        box_half_size_y_for_aper=min([ysize-y[source_id],box_half_size_for_aper0,y[source_id]-0])
        box_half_size_for_aper=round(min([box_half_size_x_for_aper,box_half_size_y_for_aper]))
        
        image_min_nomed=image[xr[source_id]-box_half_size_for_aper>0:xr[source_id]+box_half_size_for_aper<(xsize-1), $
                              yr[source_id]-box_half_size_for_aper>0:yr[source_id]+box_half_size_for_aper<(ysize-1)]
;          aper_mod,image_min_nomed,A[4],A[5],flux0,eflux,sky,skyerr,!IRC_SPECRED_CHIPINFO.ADG, $
        aper_mod,image_min_nomed,box_half_size_for_aper,box_half_size_for_aper,flux0,eflux,sky,skyerr,!IRC_SPECRED_CHIPINFO.ADG, $
                 !IRC_SPECRED_CHIPINFO.APPHOTORAD, $
                 [!IRC_SPECRED_CHIPINFO.APPHOTORAD+2<box_half_size_for_aper, $
                  !IRC_SPECRED_CHIPINFO.APPHOTORAD+4<box_half_size_for_aper], $
                 [0,0],/flux,/silent
        
        flux[source_id]=flux0
     endif else begin
        flux[source_id]=!values.f_nan
     endelse
  endfor                        ; of source_id loop
end
