pro irc_ds9_sg1_sg2_lg2,source_table_sg1,specimage_n_wc_bg_sg1,noiseimage_n_sg1, $
                        source_table_sg2,specimage_n_wc_bg_sg2,noiseimage_n_sg2,source_id_mirs, $
                        source_table_lg2,specimage_n_wc_bg_lg2,noiseimage_n_lg2,source_id_mirl,ps=ps, $
                        space_shift_sg1=space_shift_sg1,space_shift_sg2=space_shift_sg2,space_shift_lg2=space_shift_lg2, $
                        mask_sg1=mask_sg1,mask_sg2=mask_sg2,mask_lg2=mask_lg2

  if defined(mask_sg1) then specimage_n_wc_bg_sg1_work=specimage_n_wc_bg_sg1*mask_sg1 else specimage_n_wc_bg_sg1_work=specimage_n_wc_bg_sg1
  if defined(mask_sg2) then specimage_n_wc_bg_sg2_work=specimage_n_wc_bg_sg2*mask_sg2 else specimage_n_wc_bg_sg2_work=specimage_n_wc_bg_sg2
  if defined(mask_lg2) && defined(specimage_n_wc_bg_lg2) then specimage_n_wc_bg_lg2_work=specimage_n_wc_bg_lg2*mask_lg2

; user='_FOR_'+strupcase(getenv('USER'))
  set_ds9_title,'IRC_SPECRED_SG1_SG2_LG2',ds9_title

  
; Check if ds9 is already up...
  spawn,'xpaaccess -n '+ds9_title,result
  
; if ds9 is not ready, launch the new one.
  if fix(result) EQ 0 then spawn,'ds9 -title '+ds9_title+' -tile yes -height 300 -width 700 &'

; wait till ds9 is up and ready
  repeat begin
     wait,0.5
     spawn,'xpaaccess -n '+ds9_title,result
  endrep until fix(result) EQ 1

  spawn,'xpaset -p '+ds9_title+' tile grid mode manual'
  spawn,'xpaset -p '+ds9_title+' tile grid row'
  spawn,'xpaset -p '+ds9_title+' tile grid layout 3 2'
  spawn,'xpaset -p '+ds9_title+' tile yes'
  spawn,'xpaset -p '+ds9_title+' regions format ds9'
  spawn,'xpaset -p '+ds9_title+' zoom to 2'
  spawn,'xpaset -p '+ds9_title+' cmap grey'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'
  spawn,'xpaset -p '+ds9_title+' scale limits -0.5 2.5'

;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' tile grid mode manual; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' tile grid row; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' tile grid layout 3 2; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' tile yes; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' regions format ds9; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' zoom to 2; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' cmap grey; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' scale limits -0.5 2.5'


  spawn,'xpaset -p '+ds9_title+' frame 1'
  filename_specimage_sg1=strcompress(!IRC_SPECRED_DIR.tmpdir+'/SG1.'+string(source_id_mirs)+'.fits',/remove_all)
  file_delete,filename_specimage_sg1,/allow_nonexistent
  mwrfits,specimage_n_wc_bg_sg1_work[*,*,source_id_mirs],filename_specimage_sg1,/silent
  spawn,'xpaset -p '+ds9_title+' file '+filename_specimage_sg1
  spawn,'xpaset -p '+ds9_title+' rotate to 270'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' file '+filename_specimage_sg1+'; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' rotate to 270; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

  spawn,'xpaset -p '+ds9_title+' frame 2'
  filename_specimage_sg2=strcompress(!IRC_SPECRED_DIR.tmpdir+'/SG2.'+string(source_id_mirs)+'.fits',/remove_all)
  file_delete,filename_specimage_sg2,/allow_nonexistent
  mwrfits,specimage_n_wc_bg_sg2_work[*,*,source_id_mirs],filename_specimage_sg2,/silent
  spawn,'xpaset -p '+ds9_title+' file '+filename_specimage_sg2
  spawn,'xpaset -p '+ds9_title+' rotate to 270'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

; spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' file '+filename_specimage_sg2+'; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' rotate to 270; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'


  if defined(specimage_n_wc_bg_lg2) then begin
     spawn,'xpaset -p '+ds9_title+' frame 3'
     filename_specimage_lg2=strcompress(!IRC_SPECRED_DIR.tmpdir+'/LG2.'+string(source_id_mirl)+'.fits',/remove_all)
     file_delete,filename_specimage_lg2,/allow_nonexistent
     mwrfits,specimage_n_wc_bg_lg2_work[*,*,source_id_mirl],filename_specimage_lg2,/silent
     spawn,'xpaset -p '+ds9_title+' file '+filename_specimage_lg2
     spawn,'xpaset -p '+ds9_title+' rotate to 90'
;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar'
;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1'
;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' file '+filename_specimage_lg2+'; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' rotate to 90; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

  endif

;;;

  spawn,'xpaset -p '+ds9_title+' frame 4'
  filename_noiseimage_sg1=strcompress(!IRC_SPECRED_DIR.tmpdir+'/SG1.'+string(source_id_mirs)+'.noise.fits',/remove_all)
  file_delete,filename_noiseimage_sg1,/allow_nonexistent
  mwrfits,noiseimage_n_sg1[*,*,source_id_mirs],filename_noiseimage_sg1,/silent
  spawn,'xpaset -p '+ds9_title+' file '+filename_noiseimage_sg1
  spawn,'xpaset -p '+ds9_title+' rotate to 270'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' file '+filename_noiseimage_sg1+' ;xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' rotate to 270; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

  spawn,'xpaset -p '+ds9_title+' frame 5'
  filename_noiseimage_sg2=strcompress(!IRC_SPECRED_DIR.tmpdir+'/SG2.'+string(source_id_mirs)+'.noise.fits',/remove_all)
  file_delete,filename_noiseimage_sg2,/allow_nonexistent
  mwrfits,noiseimage_n_sg2[*,*,source_id_mirs],filename_noiseimage_sg2,/silent

  spawn,'xpaset -p '+ds9_title+' file '+filename_noiseimage_sg2
  spawn,'xpaset -p '+ds9_title+' rotate to 270'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1'
;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

;  spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' file '+filename_noiseimage_sg2+'; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' rotate to 270; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

  if defined(specimage_n_wc_bg_lg2) then begin
     spawn,'xpaset -p '+ds9_title+' frame 6'
     filename_noiseimage_lg2=strcompress(!IRC_SPECRED_DIR.tmpdir+'/LG2.'+string(source_id_mirl)+'noise.fits',/remove_all)
     file_delete,filename_noiseimage_lg2,/allow_nonexistent
     mwrfits,noiseimage_n_lg2[*,*,source_id_mirl],filename_noiseimage_lg2,/silent
     spawn,'xpaset -p '+ds9_title+' file '+filename_noiseimage_lg2
     spawn,'xpaset -p '+ds9_title+' rotate to 90'
;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar'
;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1'
;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' file '+filename_noiseimage_lg2+' ;xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' rotate to 90; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth function Boxcar; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth radius 1; xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' smooth'

  endif
;;;

  n_source_mirs=n_elements(source_table_sg1)
  use_array_mirs=indgen(n_source_mirs)+1  ; array starts from 1, not from zero.
  s=size(specimage_n_wc_bg_sg1_work) & dx_sg1=(s[1]-1)/2 & dy_sg1=(s[2]-1)/2
  s=size(specimage_n_wc_bg_sg2_work) & dx_sg2=(s[1]-1)/2 & dy_sg2=(s[2]-1)/2

  if defined(space_shift_sg1) then dx_sg1+=space_shift_sg1
  if defined(space_shift_sg2) then dx_sg2+=space_shift_sg2

  if defined(specimage_n_wc_bg_lg2) then begin
     n_source_mirl=n_elements(source_table_lg2)
     use_array_mirl=indgen(n_source_mirl)+1 ; array starts from 1, not from zero.
     s=size(specimage_n_wc_bg_lg2_work) & dx_lg2=(s[1]-1)/2 & dy_lg2=(s[2]-1)/2
     if defined(space_shift_lg2) then dx_lg2-=space_shift_lg2
  endif

  spawn,'xpaset -p '+ds9_title+' frame 1'
  regionfilename_sg1=!IRC_SPECRED_DIR.tmpdir+'/irc_ds9_sg1_tmp.reg'
  file_delete,regionfilename_sg1,/allow_nonexistent
; write_ds9_region_file,source_table_sg1,filename=regionfilename_sg1,space_shift=space_shift,nsum=nsum
  change_filter_spec,'S9W_SG1'
  ds9_make_region_files,source_table_sg1,dx_sg1,dy_sg1,use_array_mirs,regionfilename0=regionfilename_sg1
  regionfilename_sg1=strcompress(regionfilename_sg1+string(source_id_mirs+1)+'.reg',/remove_all)
  spawn,'xpaset -p '+ds9_title+' regions load '+regionfilename_sg1

  spawn,'xpaset -p '+ds9_title+' frame 2'
  regionfilename_sg2=!IRC_SPECRED_DIR.tmpdir+'/irc_ds9_sg2_tmp.reg'
  file_delete,regionfilename_sg2,/allow_nonexistent
;  write_ds9_region_file,source_table_sg2,filename=regionfilename_sg2,space_shift=space_shift,nsum=nsum
  change_filter_spec,'S9W_SG2'
  ds9_make_region_files,source_table_sg2,dx_sg2,dy_sg2,use_array_mirs,regionfilename0=regionfilename_sg2
  regionfilename_sg2=strcompress(regionfilename_sg2+string(source_id_mirs+1)+'.reg',/remove_all)
  spawn,'xpaset -p '+ds9_title+' regions load '+regionfilename_sg2

  if defined(specimage_n_wc_bg_lg2) then begin
     spawn,'xpaset -p '+ds9_title+' frame 3'
     regionfilename_lg2=!IRC_SPECRED_DIR.tmpdir+'/irc_ds9_lg2_tmp.reg'
     file_delete,regionfilename_lg2,/allow_nonexistent
; write_ds9_region_file,source_table_lg2,filename=regionfilename_lg2,space_shift=space_shift,nsum=nsum
     change_filter_spec,'L18W_LG2'
     ds9_make_region_files,source_table_lg2,dx_lg2,dy_lg2,use_array_mirl,regionfilename0=regionfilename_lg2
     regionfilename_lg2=strcompress(regionfilename_lg2+string(source_id_mirl+1)+'.reg',/remove_all)
     spawn,'xpaset -p '+ds9_title+' regions load '+regionfilename_lg2
  endif

; PS output

  if keyword_set(ps) then begin
;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' print filename '+ps
;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' print destination file'
;     spawn,'xpaset -p IRC_SPECRED_SG1_SG2_LG2'+user+' print'
     spawn,'xpaset -p '+ds9_title+' print filename '+ps+'; xpaset -p '+ds9_title+' print destination file; xpaset -p '+ds9_title+' print'

  endif

end
