pro irc_list_read,list,num,dir=dir,list_in=list_in,mytitle=mytitle

; select a list of files '*.lst' from disk,
; return an array of file names found in a list, and number of files
;
; input: filename of list file (option)
; output: list: an array of file names in a list
;         num: number of files in a list

  if ~ keyword_set(dir) then dir='.'
  cd,dir

  if ~ defined(mytitle) then mymytitle='Input a file of fiels' else mymytitle=mytitle

  if keyword_set(list_in) EQ 0 then $
     filename=DIALOG_PICKFILE(FILTER = '*.lst',title=mymytitle,path=dir) $
  else $
     filename=list_in

  if strlen(filename) EQ 0 then print,'Warning (irc_list_read): The input list file is null!',filename

  READCOL, filename, FORMAT='A', list
  dim = SIZE(list)
  num = dim[1]

  if num EQ 0 then print,'Warning (irc_list_read): The input list file is empty!',filename

END
