pro irc_shift_image_cube,image3d,dx,dy,image3d_shift, $
                         imag=imag,short=short,subpix=subpix

  common gui,logger

  s=size(image3d)
  if s[0] EQ 3 then n_frame0=s[3] else n_frame0=1
  xsize=s[1] & ysize=s[2]
  image3d_shift=fltarr(size(image3d,/dimensions))
  
  n_dx=n_elements(dx)

  if (n_frame0 NE n_dx) then begin
     print,'Warning (irc_shift_image_cube): # of subframes and # of shift information measured with NP or NG or S9W are not same!'
     print,n_frame0,n_dx
     n_frame=min([n_frame0,n_dx])
  endif else $
     n_frame=n_frame0
  
  logger->append,['  Image shift dx, dy (pix)']

  if !IRC_SPECRED_PROCESSOPTION.mir_fileshift_mode EQ 1 then begin
     read_image_shift_info,id,d_dx,d_dy,filename=!IRC_SPECRED_DIR.workdir+'/MIR_SHIFT_XY.dat'
;    print,d_dx,d_dy
     dx+=d_dx
     dy+=d_dy
  endif


  if ~ keyword_set(subpix) then begin  
     for i=0,n_frame-1 do begin
        image3d_shift[*,*,i]=shift(image3d[*,*,i],-round(dx[i]),-round(dy[i]))
                                ; edge of the shifted images will be masked out.
        if -round(dx[i]) GT 0 then image3d_shift[0:-round(dx[i]),*,i]           =!values.F_NAN
        if -round(dx[i]) LT 0 then image3d_shift[xsize-round(dx[i]):xsize-1,*,i]=!values.F_NAN
        if -round(dy[i]) GT 0 then image3d_shift[*,0:-round(dy[i]),i]           =!values.F_NAN
        if -round(dy[i]) LT 0 then image3d_shift[*,ysize-round(dy[i]):ysize-1,i]=!values.F_NAN
        
        logger->append,['    Subframe id'+string(i)+': '+string(dx[i])+string(dy[i])]
     endfor
  endif else begin
     for i=0,n_frame-1 do begin
        image3d_shift[*,*,i]=sshift2d(image3d[*,*,i],[-dx[i],-dy[i]])
                                ; edge of the shifted images will be masked out.
        if -round(dx[i]) GT 0 then image3d_shift[0:-round(dx[i]),*,i]           =!values.F_NAN
        if -round(dx[i]) LT 0 then image3d_shift[xsize-round(dx[i]):xsize-1,*,i]=!values.F_NAN
        if -round(dy[i]) GT 0 then image3d_shift[*,0:-round(dy[i]),i]           =!values.F_NAN
        if -round(dy[i]) LT 0 then image3d_shift[*,ysize-round(dy[i]):ysize-1,i]=!values.F_NAN
        
        logger->append,['    Subframe id'+string(i)+': '+string(dx[i])+string(dy[i])]
     endfor
  endelse
     
end
