pro irc_show_aperture_n_on_ds9,source_table,image3d,specimage3d, $
                               filter_spec=filter_spec,no_refimage=no_refimage,show_id=show_id

; Show apertures on spec_images with DS9

  if ~ defined(image3d) || keyword_set(no_refimage) || (max(image3d) EQ 0.0 && min(image3d) EQ 0.0) then $
     no_refimage=1
 
  set_ds9_title,'IRC_SPECRED_EXTRACTED_IMAGES',ds9_title

  if defined(source_table) then begin
     n_source=n_elements(source_table)
  endif else begin
     s=size(specimage3d) & if s[0] EQ 3 then n_source=s[3] else n_source=1
  endelse
  
  s=size(specimage3d) & xsize=s[1]
  if ~ defined(image3d) then image3d=make_array(xsize,xsize,n_source,/float)
  
  ds9_init,n_source,title=ds9_title
  spawn,'xpaset -p '+ds9_title+' zoom 1',result
  ds9_make_fits_files,image3d,specimage3d,no_refimage=no_refimage
  ds9_fits_file_read,n_source,title=ds9_title

; spawn,'xpaset -p '+ds9_title+' tile grid mode automatic',result
  spawn,'xpaset -p '+ds9_title+' tile grid layout 8 5',result; was 8 6
  spawn,'xpaset -p '+ds9_title+' tile grid mode manual',result


  if defined(source_table) then begin
     s=size(specimage3d) & dx=(s[1]-1)/2 & dy=(s[2]-1)/2
     if ~ keyword_set(no_refimage) then begin
        s=size(image3d) & dy=dy+s[2] ; must add hight for bottom image view
     endif
     use_array=indgen(n_source)+1 ; array starts from 1, not from zero.
     if defined(filter_spec) then $
        regionfilename1=!IRC_SPECRED_DIR.tmpdir+strim(filter_spec)+'.' $
     else $
        regionfilename1=!IRC_SPECRED_DIR.tmpdir 
     ds9_make_region_files,source_table,dx,dy,use_array,regionfilename0=regionfilename1
     ds9_region_file_load,n_source,use_array,regionfilename0=regionfilename1,title=ds9_title
  endif
  
  if defined(show_id) then begin
     spawn,'xpaset -p '+ds9_title+' frame '+string(show_id+1),result
     spawn,'xpaset -p '+ds9_title+' tile no',result
  endif
  
end
