pro irc_skyadjust_cube,image,outimage, $
                       mode_norm=mode_norm,sigma=sigma,ceil=ceil,bottom=bottom,use_array=use_array, $
                       make_list_only=make_list_only

  common gui,logger

  s=size(image) & xsize=s[1] & ysize=s[2]
  if s[0] EQ 2 then begin
     print,'Warning (irc_skyadjust_cube): Input image cube has only 2D... No skyadjust will be made (Output=Input)!'
     outimage=image
     return
  endif
  n_cube=s[3]
  skycount=fltarr(n_cube) & sigma=fltarr(n_cube) & d_sky=fltarr(n_cube) & sigma_tmp_array=fltarr(n_cube)

  if defined(use_array) EQ 0 then begin
     use_array=intarr(n_cube)
     use_array_predefined=0B
  endif else begin
     use_array_predefined=1B
  endelse

  for i=0,n_cube-1 do begin
     irc_calcsky_mmm,image[*,*,i],skymod,sigma_tmp
     skycount[i]=skymod
     sigma_tmp_array[i]=sigma_tmp
     d_sky[i]=skycount[0]-skycount[i]
  endfor

  if ~ keyword_set(make_list_only) then begin
     outimage_tmp=image
     for i=0,n_cube-1 do begin
        if keyword_set(mode_norm) then begin
           outimage_tmp[*,*,i]/=skycount[i]
           sigma[i]=sigma_tmp_array[i]/skycount[i]
        endif else $
           outimage_tmp[*,*,i]+=d_sky[i]
     endfor
  endif

  n_good=0     
  if use_array_predefined then begin
     for i=0,n_cube-1 do begin
        if use_array[i] EQ 0 then begin
           if ~ keyword_set(make_list_only) then outimage_tmp[*,*,i]=!values.f_nan
           print,'sky level ('+string(i)+')= '+string(skymod)+' (offset= '+string(d_sky)+' )'
        endif else begin
           print,'sky level ('+string(i)+')= '+string(skymod)+' (offset= '+string(d_sky)+' ): GOOD'
           n_good+=1
           use_array[i]=1
        endelse
     endfor
  endif else begin
     if keyword_set(ceil) then begin
        for i=0,n_cube-1 do begin
           if (skycount[i] GT ceil || skycount[i] LT bottom) then begin
              if ~ keyword_set(make_list_only) then outimage_tmp[*,*,i]=!values.f_nan
              print,'sky level ('+string(i)+')= '+string(skycount[i])+' (offset= '+string(d_sky[i])+' )'
           endif else begin
              print,'sky level ('+string(i)+')= '+string(skycount[i])+' (offset= '+string(d_sky[i])+' ): GOOD'
              n_good+=1
              use_array[i]=1
           endelse
        endfor
     endif else begin
        for i=0,n_cube-1 do begin
           n_good+=1
           use_array[i]=1
        endfor
     endelse
  endelse
  
  if keyword_set(ceil) then print,'Information (irc_skyadjust_cube): N of available frames: ',n_good

; remove bad frames to reduce cube size...
  outimage=fltarr(xsize,ysize,n_good)
  
  if ~ keyword_set(make_list_only) then begin
     j=0
     for k=0,n_cube-1 do begin
        if use_array[k] EQ 1 then begin
           outimage[*,*,j]=outimage_tmp[*,*,k]
           j+=1
        endif
     endfor
  endif
  
end
