pro load_ext_source_table,source_table,ext_source_table,image=image, $
                          source_table_offset_x_value=source_table_offset_x_value, $
                          source_table_offset_y_value=source_table_offset_y_value

  common gui,logger

  read_target_table,source_table,ext_source_table=ext_source_table, $
                    source_table_offset_x_value=source_table_offset_x_value, $
                    source_table_offset_y_value=source_table_offset_y_value
  
  n_source=n_elements(source_table)
  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin                   ; NIR (needs coord. rotation)
        if !IRC_SPECRED_PROCESSOPTION.rotated_NIR_source_table_mode EQ 0B then begin
           xxx=source_table.image_x & yyy=source_table.image_y
           source_table.image_x=(!IRC_SPECRED_CHIPINFO.ncol-1)-yyy & source_table.image_y=xxx
        endif
     end
     1:
     2: begin                   ; LG (needs MIRS-MIRL sep)
        for source_id=0,n_source-1 do $
           if source_table[source_id].image_y GT !IRC_SPECRED_CHIPINFO.nrow then $
              source_table[source_id].image_y-=!IRC_SPECRED_CHIPINFO.nrow
     end
  endcase
  
  if (~ defined(image)) || $
     (!IRC_SPECRED_OBSPARAM.slit_mode EQ 1B) || $
     (!IRC_SPECRED_PROCESSOPTION.no_tune_sourcepos_mode EQ 1B) $ ; no do_tune_sourcepose
  then return

  n_source=n_elements(source_table)
  x_error=fltarr(n_source) & y_error=fltarr(n_source)

  x=source_table.image_x & y=source_table.image_y
  do_tune_sourcepos,image,source_table,x,y,x_new,y_new,flux=flux,FWHM=FWHM,use_array=use_array,median=median
  x_error=x-source_table.image_x & y_error=y-source_table.image_y
  x_error=x-x_new & y_error=y-y_new

  if x_error[0] GT 0.5 || y_error[0] GT 0.5 then $
     print,'Warning (load_ext_source_table): source positions in the external source table seem to have some offset: x= ' $
           +string(x_error[0])+' y= '+string(y_error[0])

  return

; make a log
  n_source=n_elements(source_table)
  for source_id=0,n_source-1 do begin
     result=where(use_array EQ source_id,count)
     case 1 of
        (abs(x_error[source_id]) GT 0.5 || abs(y_error[source_id]) GT 0.5): begin
           logger->append,[string(source_id)+' th source pos was not accurate enough! dx=' $
                        +string(x_error[source_id])+'; dy='+string(y_error[source_id])+', but is corrected.']
        end
        (count EQ 0): begin
           logger->append,[string(source_id)+' th source pos fit was bad!']
        end
        else: logger->append,[string(source_id)+' th source pos looks fine! dx=' $
                              +string(x_error[source_id])+'; dy='+string(y_error[source_id])+', and is fine-tuned.']
     endcase
  endfor

end
