pro make_hotpixel_mask,image,image_mask
; image and mask_grow are in 2D

  mask=make_array(size(image,/dimensions),/float,value=1.)
  image_sigmafilter=sigma_filter(image,radius=1,/all,/iter)
  image_hotpixel=image-image_sigmafilter
  image_hotpixel-=median(image_hotpixel)
  rms=robust_sigma_mod(image_hotpixel) > 1e-9
  
  badarea=where(abs(image_hotpixel) GT 3.*rms,count)
  if count GT 0 then mask[badarea]=!values.F_NAN
  image_mask=image*mask

end
