pro make_image_n,refimage,specimage,source_table,refimage_n,specimage_n

  n_source=n_elements(source_table)
  refimage_n =fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dy,n_source)
  specimage_n=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx, !IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy, n_source)
  
  x_ref =round(source_table.image_x)-(!IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dx-1)/2
  y_ref =round(source_table.image_y)-(!IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dy-1)/2
  x_spec=round(source_table.spec_x)-(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2
  y_spec=round(source_table.spec_y)-(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1)/2
  
  FOR source_id=0,n_source-1 DO begin
     if finite(source_table[source_id].image_x) && finite(source_table[source_id].image_y) then begin
        refimage_n[*,*,source_id]= $
           extrac(refimage,$
                  x_ref[source_id],y_ref[source_id], $
                  !IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dy)
        specimage_n[*,*,source_id]= $
           extrac(specimage,$
                  x_spec[source_id],y_spec[source_id], $
                  !IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)

     endif else begin           ; when source pos is out of range...
        refimage_n[*,*,source_id] =fltarr( $
                                   !IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dx, $
                                   !IRC_SPECRED_SPECEXTRACTPARAM.imageaper_dy)
        specimage_n[*,*,source_id]=fltarr( $
                                   !IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx, $
                                   !IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)
     endelse
  ENDFOR
  
end
