pro make_image_n_4d,specimage_whole_3d,source_table,specimage_4d

  n_source=n_elements(source_table)
  s=size(specimage_whole_3d) & if s[0] EQ 3 then n_frame=s[3] else n_frame=0

  specimage_4d=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy,n_source,n_frame)
  
  x_spec=round(source_table.spec_x)-(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1)/2
  y_spec=round(source_table.spec_y)-(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy-1)/2
  
  for frame_id=0,n_frame-1 do begin
     FOR source_id=0,n_source-1 DO begin
        if finite(source_table[source_id].image_x) && finite(source_table[source_id].image_y) then begin

           specimage_whole_3d_tmp=specimage_whole_3d[*,*,frame_id]
           specimage_4d_tmp=extrac(specimage_whole_3d_tmp,$
                                   x_spec[source_id],y_spec[source_id], $
                                   !IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)
           specimage_4d[*,*,source_id,frame_id]=specimage_4d_tmp
        endif else begin        ; when source pos is out of range...
           specimage_4d[*,*,source_id,frame_id]=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy)
        endelse
     ENDFOR; of source id
  endfor; of frame_id

end
