pro make_average_spectra,a,b,sum

  s=size(a)
  if s[0] EQ 1 then n_frame=1 else n_frame=s[2]
  spec_length=s[1]
  ab=fltarr(spec_length,2) & n=fltarr(spec_length) & sum=fltarr(spec_length,n_frame)
  
  for frame_id=0,n_frame-1 do begin
     ab[*,0]=a[*,frame_id]
     ab[*,1]=b[*,frame_id]
     sum[*,frame_id]=total(ab,2,/NAN)
  
     for i=0,s[1]-1 do begin
        tmp=where(finite(ab[i,*]),count)
        n[i]=count
     endfor
     
     sum[*,frame_id]/=n
  endfor
  
end


pro make_offspec_for_plot,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table,source_id, $
                          off_specimage_wc_1d,off_specimage_fc_1d, $
                          no_mask=no_mask,stdstar_mode=stdstar_mode, $
                          average_mode=average_mode,whole_aperture=whole_aperture, $
                          bg_sub=bg_sub,bg_nsum=bg_nsum,bg_offset=bg_offset,bg_oneside=bg_oneside,short=short, $
                          space_shift=space_shift,nsum=nsum

; set bgspec params
  if ~ defined(bg_nsum) then begin
     if defined(nsum) then bg_nsum=nsum else bg_nsum=3
  endif

  if ~ defined(bg_offset) then bg_offset=10

  make_spec1d,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
              off_specimage_wc_1d_1,off_specimage_fc_1d_1,off_sigmaimage_fc_1d_1, $
              no_mask=no_mask,stdstar_mode=stdstar_mode,average_mode=average_mode, $
              whole_aperture=whole_aperture,short=short, $
              space_shift=space_shift+bg_offset,nsum=bg_nsum,/bg_mode
  
  if ~ keyword_set(bg_oneside) then begin
     make_spec1d,specimage_n_wc,specimage_n_fc,specmask_n,sigmaimage_n_fc,source_table, $
                 off_specimage_wc_1d_2,off_specimage_fc_1d_2,off_sigmaimage_fc_1d_2, $
                 no_mask=no_mask,stdstar_mode=stdstar_mode,average_mode=average_mode, $
                 whole_aperture=whole_aperture,short=short, $
                 space_shift=space_shift-bg_offset,nsum=bg_nsum,/bg_mode
  endif

  if ~ keyword_set(bg_oneside) then begin
     make_average_spectra,off_specimage_wc_1d_1,off_specimage_wc_1d_2,off_specimage_wc_1d
;    off_specimage_wc_1d=(off_specimage_wc_1d_1+off_specimage_wc_1d_2)/2.
     make_average_spectra,off_specimage_fc_1d_1,off_specimage_fc_1d_2,off_specimage_fc_1d
;    off_specimage_fc_1d=(off_specimage_fc_1d_1+off_specimage_fc_1d_2)/2.
  endif else begin
     off_specimage_wc_1d=off_specimage_wc_1d_1
     off_specimage_fc_1d=off_specimage_fc_1d_1
  endelse

end
