pro make_space_profile,specimage2d,mask_specimage2d,xarray,space_profile

  xarray=findgen(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx)

  get_valid_y_range,cut_in,cut_out
  space_profile=fltarr(!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx)
  if ~ defined(mask_specimage2d) then begin
     mask_specimage2d=specimage2d
     mask_specimage2d[*,*]=1.
  endif

  specimage2d_sigmafilter=sigma_filter(specimage2d,radius=1,/all,/iterate)
  for x=0,!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dx-1 do begin
     mask=mask_specimage2d
     masked_region=where(mask EQ 0, count)
     if count GT 0 then mask[masked_region]=!values.f_nan
     sigma=robust_sigma_mod(specimage2d_sigmafilter)
     skymod=median(specimage2d_sigmafilter)
     clipped_region=where(specimage2d_sigmafilter LT 1.*sigma+skymod,count)
     if count GT 0 then mask[clipped_region]=!values.f_nan
     
     array=specimage2d_sigmafilter[x,cut_in:cut_out]*mask[x,cut_in:cut_out]
     calc_region=where(finite(array),count)
     if count GT 5 then begin
        mean_tmp=total(array[calc_region])
     endif else mean_tmp=0.
     space_profile[x]=mean_tmp
  endfor
  
end
