pro make_wholemask,x,y,mask_dx,mask_dy,mask, $
                   remove_source=remove_source,id=id, $
                   circular_aperture=circular_aperture,fov_mask=fov_mask,objmask=objmask, $
                   mask_use=mask_use,show_mask=show_mask,narrow_mask=narrow_mask

; INPUTS:
; x, y: object coordinates for mask
; mask_dx,mask_dy: size of mask in x and y
;
; OUTPUT
; mask
;
; Option
; circular_aperture: if set, make a round mask; else, make a box mask
; remove_soruce: if set, a mask for soruce_id=id will not be created.

  case 1 of
     defined(objmask): mask_dx2=mask_dx*!IRC_SPECRED_MASKPARAM.objmask_expand_fac
     defined(narrow_mask): mask_dx2=5
     else: mask_dx2=mask_dx*2.0
  endcase

  if ~ defined(mask_use) then begin
     mask_use=fltarr(n_elements(x))
     mask_use[*]=1.0
  endif

  get_chip_dims,xsize,ysize

; mask values definition
  good_mask_value=1. & bad_mask_value=!values.f_nan

;make an mask array
  mask=make_array(xsize,ysize,/float,value=good_mask_value)

  if keyword_set(remove_source) then rmid=id else rmid=-1 ; never match

  n_source=n_elements(x)
; for circle mask
  if keyword_set(circular_aperture) then begin
     masksize_fac=!IRC_SPECRED_MASKPARAM.circularmask_expand_fac
     ; min-box coordinates for caliculation
     yy_min=(y-(mask_dy-1)*masksize_fac*2) > 0
     yy_max=(y+(mask_dy-1)*masksize_fac*2) < (ysize-1)
     xx_min=(x-(mask_dx2-1)*masksize_fac*2) > 0
     xx_max=(x+(mask_dx2-1)*masksize_fac*2) < (xsize-1)

     FOR source_id=0,n_source-1 do begin
        if source_id NE rmid then begin
           for yy=yy_min[source_id],yy_max[source_id] do begin
              for xx=xx_min[source_id],xx_max[source_id] do begin
                 if sqrt((xx-x[source_id])^2.+(yy-y[source_id])^2.) LT (mask_dx2[source_id]-1)/2*masksize_fac $
                 then mask[xx,yy]=bad_mask_value
              endfor            ; of XX loop
           endfor               ; of YY loop
        endif
     endfor                     ; of source_id loop
     return                     ; back to calling procedure
; for box mask
  endif else begin
     if NP() then begin
        x1_n=round(x-(mask_dx2-1)/3)   > 0 < (xsize-1)
        x2_n=round(x+(mask_dx2-1)/3-1) > 0 < (xsize-1)
        y1_n=round(y-(mask_dy-1)/2)   > 0 < (ysize-1)
        y2_n=round(y+(mask_dy-1)/2-1) > 0 < (ysize-1)

        x1_w=round(x-(mask_dx2-1)/2)   > 0 < (xsize-1)
        x2_w=round(x+(mask_dx2-1)/2-1) > 0 < (xsize-1)

        y1_w=round(y-(mask_dy-1)/2)   > 0 < (ysize-1)
        y2_w=round(y-(mask_dy-1)/6-1) > 0 < (ysize-1)
        FOR source_id=0,n_source-1 do begin
           if source_id NE rmid then begin
              if x1_n[source_id] GT x2_n[source_id] then x2_n[source_id]=x1_n[source_id]
              if y1_n[source_id] GT y2_n[source_id] then y2_n[source_id]=y1_n[source_id]
              if x1_w[source_id] GT x2_w[source_id] then x2_w[source_id]=x1_w[source_id]
              if y1_w[source_id] GT y2_w[source_id] then y2_w[source_id]=y1_w[source_id]
; narrow mask
              mask[x1_n[source_id]:x2_n[source_id],y1_n[source_id]:y2_n[source_id]]=bad_mask_value
; wide mask
              mask[x1_w[source_id]:x2_w[source_id],y1_w[source_id]:y2_w[source_id]]=bad_mask_value
           endif
        endfor
     endif else begin
        x1=round(x-(mask_dx2-1)/2)   > 0 < (xsize-1)
        x2=round(x+(mask_dx2-1)/2-0) > 0 < (xsize-1)
;       y1=round(y-(mask_dy-1)/2)   > 0 < (ysize-1)
;       y2=round(y+(mask_dy-1)/2-1) > 0 < (ysize-1)

; smaller mask
        get_valid_y_range,cut_in,cut_out
        mask_dy=abs(cut_in-cut_out)+1
        specbox_offset=-(mask_dy/2.-!IRC_SPECRED_SPECEXTRACTPARAM.specaper_dy/2.+cut_in)
        y1=round(y-(mask_dy-1)/2-specbox_offset)   > 0 < (ysize-1)
        y2=round(y+(mask_dy-1)/2-0-specbox_offset) > 0 < (ysize-1)

        if defined(objmask) then begin
           s=size(objmask) & xmasksize=s[1] & ymasksize=s[2]
        endif

        for source_id=0,n_source-1 do begin
           if source_id NE rmid then begin
              if defined(objmask) then begin
; select only region where object should locate:

                 y1_mask=min([cut_in,cut_out])
                 y2_mask=max([cut_in,cut_out])

                 objmask_tmp=objmask[*,*,source_id]
;                print,source_id,mask_use[source_id]
                 y1_mask_org=y1_mask & y2_mask_org=y2_mask

                 if round(y[source_id]-(mask_dy-1)/2-specbox_offset) LT 0       then $
                    y1_mask=y2_mask_org-(y2[source_id]-y1[source_id])
                 if round(y[source_id]+(mask_dy-1)/2-specbox_offset) GT ysize-1 then $
                    y2_mask=y1_mask_org+(y2[source_id]-y1[source_id])

                 x1_mask=round((xmasksize-1)/2-(mask_dx2[source_id]-1)/2) > 0 < (xmasksize-1)
                 x2_mask=round((xmasksize-1)/2+(mask_dx2[source_id]-1)/2) > 0 < (xmasksize-1)

                 x1_mask_org=x1_mask & x2_mask_org=x2_mask

                 if round(x[source_id]-(mask_dx2[source_id]-1)/2) LT 0       then $
                    x1_mask=x2_mask_org-(x2[source_id]-x1[source_id])
                 if round(x[source_id]+(mask_dx2[source_id]-1)/2) GT xsize-1 then $
                    x2_mask=x1_mask_org+(x2[source_id]-x1[source_id])

                 x2[source_id]=x1[source_id]+(x2_mask-x1_mask) < (xsize-1)
                 y2[source_id]=y1[source_id]+(y2_mask-y1_mask) < (ysize-1)

                 x2_mask=x2[source_id]-x1[source_id]+x1_mask
                 y2_mask=y2[source_id]-y1[source_id]+y1_mask

;                print,source_id,x1_mask,x2_mask,y1_mask,y2_mask
                 objmaskcut=objmask_tmp[x1_mask:x2_mask,y1_mask:y2_mask]

                 if mask_use[source_id] EQ 1 then $
                    mask[x1[source_id]:x2[source_id],y1[source_id]:y2[source_id]]*=objmaskcut
              endif else begin  ; without objmask
                 if mask_use[source_id] EQ 1 then $
                    mask[x1[source_id]:x2[source_id],y1[source_id]:y2[source_id]]=bad_mask_value
              endelse
           endif                ; of source_id EQ rmid
        endfor                  ; of source_id loop

     endelse

     if keyword_set(show_mask) then atv,mask,/b

     if defined(fov_mask) then mask*=fov_mask
     
  endelse
 
; trim mask
  s=size(mask) & xsize=s[1] & ysize=s[2]
  mask[0,*,*]=!values.f_nan
  mask[*,0,*]=!values.f_nan
  mask[xsize-1,*,*]=!values.f_nan
  mask[*,ysize-1,*]=!values.f_nan

end
