pro mask_grow,mask,mask_grow,grow_width=grow_width,spec=spec

  s=size(mask) & xsize=s[1] & ysize=s[2]
  mask_grow=mask

  if ~ defined(grow_width) then width=1 else width=grow_width

  if keyword_set(spec) then width_y=width+2 else width_y=width

  case width of
     -1: begin                  ; special cross mask
        for y=1,ysize-2 do begin
           for x=1,xsize-2 do begin
              if finite(mask[x,y],/NAN) then begin
                 mask_grow[x-1:x+1,y:y]=!values.f_nan
                 mask_grow[x:x,y-1:y+1]=!values.f_nan
              endif
           endfor
        endfor
     end

     1: begin
        for y=width_y,ysize-width_y-1 do begin
           for x=width,xsize-width-1 do begin
              nan_region=where(finite(mask[x-1:x+1,y-width_y:y+width_y],/NAN),nan_count)
              if nan_count GE 3 then mask_grow[x-width:x+width,y-width_y:y+width_y]=!values.f_nan
;              if finite(mask[x,y],/NAN) then begin
;                 mask_grow[x-width:x+width,y-width_y:y+width_y]=!values.f_nan
;              endif
           endfor
        endfor
     end
     
     2: begin
        for y=width_y,ysize-width_y-1 do begin
           for x=width,xsize-width-1 do begin
;             if finite(mask[x,y],/NAN) then begin
              nan_region=where(finite(mask[x-1:x+1,y-width_y:y+width_y],/NAN),nan_count)
              if nan_count GE 3 then mask_grow[x-width:x+width,y-width_y:y+width_y]=!values.f_nan
;             mask_grow[x-width:x+width,y-width_y:y+width_y]=!values.f_nan
           endfor
        endfor
     end
  
;     3: begin
;        for y=width_y,ysize-width_y-1 do begin
;           for x=width,xsize-width-1 do begin
;              if finite(mask[x,y],/NAN) then begin
;                 mask_grow[x-width:x+width,y-width_y:y+width_y]=!values.f_nan
;              endif
;           endfor
;        endfor
;     end

     3: begin
        for y=width_y,ysize-width_y-1 do begin
           for x=width,xsize-width-1 do begin
              nan_region=where(finite(mask[x-1:x+1,y-width_y:y+width_y],/NAN),nan_count)
              if nan_count GE 3 then mask_grow[x-width:x+width,y-width_y:y+width_y]=!values.f_nan
           endfor
        endfor
     end
 
      4: begin
        for y=width_y,ysize-width_y-1 do begin
           for x=width,xsize-width-1 do begin
              nan_region=where(finite(mask[x-width:x+width,y-width_y:y+width_y],/NAN),nan_count)
              if nan_count GE 3 then mask_grow[x-width:x+width,y-width_y:y+width_y]=!values.f_nan
           endfor
        endfor
     end
 
     
     else: begin                ; same as widgth=2
        for y=2,ysize-3 do begin
           for x=2,xsize-3 do begin
              if finite(mask[x,y],/NAN) then begin
                 mask_grow[x-2:x+2,y-2:y+2]=!values.f_nan
              endif
           endfor
        endfor
     end
     
  endcase
  
end


