function meanclip_smooth,image,dx,dy,clip_sig=clip_sig

  if defined(clip_sig) then clipsig=clip_sig else clipsig=3.

  outimage=filter_image_nan(image,median=min([2*dx+1,2*dy+1]),/all)

  s=size(image) & xsize=s[1] & ysize=s[2]
  
  typical_sigma=robust_sigma(image)

  for y=dy,ysize-1-dy do begin
     image_cut=image[*,y-dy:y+dy]
     for x=dx,xsize-1-dx do begin
        image_cut2=image_cut[x-dx:x+dx,*]
        meanclip_mod,image_cut2,avg,sig,clipsig=clipsig,sigma_set=typical_sigma
        outimage[x,y]=avg
     endfor
  endfor
  
  return,outimage
end
