pro oplot_line_lambda,lambda,yrange,wave_array,wave_array_error_pix,_EXTRA=EXTRA_KEYWORDS

; lambda: line lambda
; yrange: plot range along Y axis (yrange=yrange)
; wave_array: wave_array
; expected (typical) error along wavelength axis, in units of pix.

  oplot,[lambda,lambda],yrange,_extra=extra_keywords
  
  if ~ defined(wave_array_error_pix) then wave_array_error_pix=1.
  
  if defined(wave_array) then begin
     d_wave_array=wave_array-shift(wave_array,1)
     if NP() || SG1() || SG2() then $
        pos=min(where(wave_array GT lambda,count)) $
     else $
        pos=max(where(wave_array GT lambda,count))
     if count GT 0 then begin
        shift=abs(d_wave_array[pos])*wave_array_error_pix
        oplot,[lambda+shift,lambda+shift],yrange,linestyle=2,_extra=extra_keywords
        oplot,[lambda-shift,lambda-shift],yrange,linestyle=2,_extra=extra_keywords
     endif
     
  endif
  
end
