pro plot_cohen,lambda2=lambda2

  set_dir

  data_dir=!IRC_SPECRED_DIR.calibdir+'StdSpecData/'
  cd,data_dir

  irc_list_read,list,num,dir=data_dir

  for file_id=0,num-1 do begin
     
     print,list[file_id]
     read_cohen,x,y,z,count,list[file_id]
     
;    mydevice = !D.NAME
;    SET_PLOT, 'PS'
;    DEVICE, FILENAME=!IRC_SPECRED_DIR.tmpdir+'/'+strcompress(list[file_id],/remove)+'.ps', /LANDSCAPE,/color

     if ~ keyword_set(lambda2) then begin
        plot,x,y*1000.,xrange=[1,30],/ylog,/xlog,xtitle='um',ytitle='mJy',xstyle=1
        err_plot,x,(y+z)*1000.,(y-z)*1000.
     endif else begin
        plot,x,y*x^2*1000.,xrange=[1,30],/ylog,/xlog,xtitle='um',ytitle='mJy',xstyle=1
        err_plot,x,x^2*(y+z)*1000.,x^2*(y-z)*1000.
     endelse
        
     xyouts_Y_pos=mean(y[where(x gt 1 and x lt 30)])*1000
     
     xyouts,2.43,xyouts_Y_pos,'N2',alignment=0.5,orientation=90
     xyouts,3.16,xyouts_Y_pos,'N3',alignment=0.5,orientation=90
     xyouts,4.14,xyouts_Y_pos,'N4',alignment=0.5,orientation=90
     xyouts,7.30,xyouts_Y_pos,'S7',alignment=0.5,orientation=90
     xyouts,9.10,xyouts_Y_pos,'S9W',alignment=0.5,orientation=90
     xyouts,10.7,xyouts_Y_pos,'S11',alignment=0.5,orientation=90
     xyouts,15.7,xyouts_Y_pos,'L15',alignment=0.5,orientation=90
     xyouts,18.3,xyouts_Y_pos,'L18W',alignment=0.5,orientation=90
     xyouts,23.0,xyouts_Y_pos,'L24',alignment=0.5,orientation=90
     
;    DEVICE, /CLOSE           ; Return plotting to the original device:
;    SET_PLOT, mydevice
     
  endfor
  
  message,'Finish'

end

