pro plot_cohen_jy,lambda2=lambda2,oplot=oplot

  make_env_var
  set_dir
  set_color;,/white_bg

  data_dir=!IRC_SPECRED_DIR.calibdir+'StdSpecData/'
  cd,data_dir

  filename = DIALOG_PICKFILE (FILTER = '*.tem',title='Input a tem file name',path=data_dir)
  read_cohen,x,y,z,count,filename

  if ~ keyword_set(lambda2) then begin
     plot,x,y*1000.,xrange=[1.56475,5.66334],yr=[10,10000],xtitle='um',ytitle='mJy',xstyle=1,psym=10,color=!IRC_SPECRED_COLOR.white,/ylog
     err_plot,x,(y+z)*1000.,(y-z)*1000.
  endif else begin
     if keyword_set(oplot) then $
        oplot,x,x^2*y*1000,psym=10,color=!IRC_SPECRED_COLOR.white $
     else $
        plot,x,x^2*y*1000.,xrange=[1.56475,5.66334],yr=[10,20000],xtitle='um',ytitle='mJy',xstyle=1,psym=10,color=!IRC_SPECRED_COLOR.white,/ylog

     err_plot,x,x^2*(y+z)*1000.,x^2*(y-z)*1000.
  endelse

  xyouts_Y_pos=mean(y[where(x gt 1 and x lt 30)])*1000.
  
  xyouts,2.43,xyouts_Y_pos,'N2',alignment=0.5,orientation=90
  xyouts,3.16,xyouts_Y_pos,'N3',alignment=0.5,orientation=90
  xyouts,4.14,xyouts_Y_pos,'N4',alignment=0.5,orientation=90
  xyouts,7.30,xyouts_Y_pos,'S7',alignment=0.5,orientation=90
  xyouts,9.10,xyouts_Y_pos,'S9W',alignment=0.5,orientation=90
  xyouts,10.7,xyouts_Y_pos,'S11',alignment=0.5,orientation=90
  xyouts,15.7,xyouts_Y_pos,'L15',alignment=0.5,orientation=90
  xyouts,18.3,xyouts_Y_pos,'L18W',alignment=0.5,orientation=90
  xyouts,23.0,xyouts_Y_pos,'L24',alignment=0.5,orientation=90
  
;  message,'Finish'

; write_spec,x,y*1000.,(y+z)*1000.,(y-z)*1000.,/no_wl_limit

end

