pro plot_spec,lambda,flux,flux2,flux3,lambda_2,lambda_3, $
              watt=watt,mjy=mjy,diffuse=diffuse,wc=wc,lambda2=lambda2,oplot=oplot, $
              errory=errory,errorxy=errorxy,clip_range=clip_range, $
              space_shift=space_shift,nsum=nsum, $
              _EXTRA=EXTRA_KEYWORDS

  if ~ defined(nsum) then nsum=3
  if ~ defined(space_shift) then space_shift=0

  if ~ defined(flux2) then flux2=flux
  if ~ defined(flux3) then flux3=flux
  if ~ defined(lambda_2) then lambda_2=lambda
  if ~ defined(lambda_3) then lambda_3=lambda

  case 1 of
     (keyword_set(watt)): begin
        flux_plot=jansky_to_w_cm2_um(lambda,flux)
        flux2_plot=jansky_to_w_cm2_um(lambda,flux2)
        flux3_plot=jansky_to_w_cm2_um(lambda,flux3)
     end
     (keyword_set(mjy)): begin
        flux_plot=flux*1000.
        flux2_plot=flux2*1000.
        flux3_plot=flux3*1000.
     end
     (keyword_set(lambda2)): begin
        flux_plot=flux*1000.*lambda^2.
        flux2_plot=flux2*1000.*lambda^2.
        flux3_plot=flux3*1000.*lambda^2.
     end
     (keyword_set(diffuse)): begin
        arcsec2=nsum*!IRC_SPECRED_CHIPINFO.pixscale_x*5. ;!IRC_SPECRED_CHIPINFO.slit_width

        flux_plot=jansky_to_megajansky_per_str(flux,arcsec2)
        flux2_plot=jansky_to_megajansky_per_str(flux2,arcsec2)
        flux3_plot=jansky_to_megajansky_per_str(flux3,arcsec2)
     end
     else: begin
        flux_plot=flux
        flux2_plot=flux2
        flux3_plot=flux3
     end
  endcase
  
  if ~ defined(ytitle) then begin
     case 1 of
        (keyword_set(wc)): ytitle='Count (ADU)'
        (keyword_set(mjy)): ytitle='Flux (mJy)'
        (keyword_set(lambda2)): ytitle='Flux*um^2 (mJy*um^2)'
        (keyword_set(watt)): ytitle='Flux (W cm-2 s-1)'
        (keyword_set(diffuse)): ytitle='Surface Flux Density (MJy/Str)'
        else: ytitle=''
     endcase
  endif

  case 1 of
     (keyword_set(oplot)): begin
;       oplot,lambda,flux_plot,_extra=extra_keywords
        if keyword_set(clip_range) then $
           plot,lambda,flux_plot,_extra=extra_keywords,/noerase,clip=clip_range,noclip=0,xstyle=5,ystyle=5 $
        else $
;          plot,lambda,flux_plot,_extra=extra_keywords,/noerase,xstyle=5,ystyle=5
           oplot,lambda,flux_plot,_extra=extra_keywords;,xstyle=5,ystyle=5
     end
     (keyword_set(errory)): begin
        err_plot_mod,lambda,flux_plot,flux2_plot,_extra=extra_keywords
     end
     (keyword_set(errorxy)): begin
        if keyword_set(clip_range) then $
           err_plot_xy,lambda,flux_plot,flux2_plot,flux3_plot,lambda_2,lambda_3,_extra=extra_keywords,clip=clip_range,noclip=0 $
        else $
           err_plot_xy,lambda,flux_plot,flux2_plot,flux3_plot,lambda_2,lambda_3,_extra=extra_keywords
     end
     else: begin
        if keyword_set(clip_range) then $
           plot,lambda,flux_plot,xtitle='Wavelength (um)',ytitle=ytitle,_extra=extra_keywords,clip=clip_range,noclip=0 $
        else $
           plot,lambda,flux_plot,xtitle='Wavelength (um)',ytitle=ytitle,_extra=extra_keywords
     end
  endcase

end
