pro plot_spec_obs,wave_array,specimage_fc_1d_smooth,error_p_fc_total,error_n_fc_total,d_wave_array, $
                  redshift=redshift, $
                  mjy=mjy,watt=watt,diffuse=diffuse,lambda2=lambda2, $
                  with_image=with_image,_EXTRA=EXTRA_KEYWORDS, $
                  oplot=oplot, $
                  space_shift=space_shift,nsum=nsum, $
                  plot_color=plot_color, $
                  x_range_set=x_range_set,clip_range=clip_range

  if ~ defined(redshift) then redshift=0.
  if ~ defined(plot_color) then plot_color=!IRC_SPECRED_COLOR.white

  if keyword_set(with_image) then begin
     x_range_set=[wave_array[0],wave_array[n_elements(wave_array)-1]]
     if NG() || LG2() then x_range_set=[x_range_set[1],x_range_set[0]]

     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth,mJy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse, $
               psym=6,color=!IRC_SPECRED_COLOR.white, $
               xrange=x_range_set, $
               _extra=extra_keywords,oplot=oplot,clip_range=clip_range,space_shift=space_shift,nsum=nsum
     
     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse, $
               psym=6,color=!IRC_SPECRED_COLOR.blue,/oplot, $
               xrange=x_range_set, $
               clip_range=clip_range,space_shift=space_shift,nsum=nsum,_extra=extra_keywords
     
     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth, $
               specimage_fc_1d_smooth-error_n_fc_total,specimage_fc_1d_smooth+error_p_fc_total, $
               wave_array/(1.+redshift)-d_wave_array,wave_array/(1.+redshift)+d_wave_array, $
               mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse, $
               color=!IRC_SPECRED_COLOR.red,width=0,psym=0,/errorxy, $
               xrange=x_range_set, $
               clip_range=clip_range,space_shift=space_shift,nsum=nsum,_EXTRA=EXTRA_KEYWORDS
     
; overplot the result at the very end for clarity of the plot.
     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth, $
               psym=6,color=!IRC_SPECRED_COLOR.blue,/oplot, $
               xrange=x_range_set, $
               mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse, $
               clip_range=clip_range,space_shift=space_shift,nsum=nsum,_extra=extra_keywords
     
; plot observed spectrum with histograms
     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth, $
               psym=10,color=plot_color,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse, $ ; was white
               xrange=x_range_set, $
               clip_range=clip_range,space_shift=space_shift,nsum=nsum,_extra=extra_keywords

; plot baseline (flux=0)
     plot_spec,wave_array/(1.+redshift),fltarr(n_elements(wave_array)), $
               xrange=x_range_set, $
               linestyle=2,color=!IRC_SPECRED_COLOR.white,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse,$
               clip_range=clip_range,space_shift=space_shift,nsum=nsum,_extra=extra_keywords
     
  endif else begin
     x_range_set=!IRC_SPECRED_SPECPARAM.w_cover
     if NG() || LG2() then x_range_set=[x_range_set[1],x_range_set[0]]

     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth,mJy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse, $
               xrange=x_range_set,psym=6,color=!IRC_SPECRED_COLOR.white, $
               _extra=extra_keywords,oplot=oplot,clip_range=clip_range,space_shift=space_shift,nsum=nsum

     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth, $
               xrange=x_range_set,psym=6,color=!IRC_SPECRED_COLOR.blue, $
               _extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse,clip_range=clip_range,space_shift=space_shift,nsum=nsum
     
     ; error bar
     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth, $
               specimage_fc_1d_smooth-error_n_fc_total,specimage_fc_1d_smooth+error_p_fc_total, $
               wave_array/(1.+redshift)-d_wave_array,wave_array/(1.+redshift)+d_wave_array, $
               xrange=x_range_set,color=!IRC_SPECRED_COLOR.red,width=0,psym=0,/errorxy,mjy=mjy,watt=watt,lambda2=lambda2, $
               _EXTRA=EXTRA_KEYWORDS,diffuse=diffuse,clip_range=clip_range,space_shift=space_shift,nsum=nsum
     
; overplot the result at the very end for clarity of the plot.
     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth, $
               xrange=x_range_set,psym=6,color=!IRC_SPECRED_COLOR.blue, $
               _extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse,clip_range=clip_range,space_shift=space_shift,nsum=nsum
  
; plot observed spectrum with histograms
     plot_spec,wave_array/(1.+redshift),specimage_fc_1d_smooth, $
               xrange=x_range_set,psym=10,color=plot_color, $; was white
               _extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse,clip_range=clip_range,space_shift=space_shift,nsum=nsum
  
; plot baseline (flux=0)
     plot_spec,wave_array/(1.+redshift),fltarr(n_elements(wave_array)), $
               xrange=x_range_set,linestyle=2,color=!IRC_SPECRED_COLOR.white, $
               _extra=extra_keywords,/oplot,mjy=mjy,watt=watt,lambda2=lambda2,diffuse=diffuse,clip_range=clip_range,space_shift=space_shift,nsum=nsum

  endelse
  
  
end
