pro process_header,specheader,imagheader,source_table,specheader_extract,imagheader_extract
  
  s=size(specheader) & n_item=s[1] & if s[0] EQ 2 then n_specheader=s[2] else n_specheader=1
  s=size(imagader)                 & if s[0] EQ 2 then n_imagheader=s[2] else n_imagheader=1
  
  fxaddpar_n,imagheader,'EXPTIME',!IRC_SPECRED_CHIPINFO.exptime
  
  case !IRC_SPECRED_PROCESSTARGET.chip of
     0: begin
        fxaddpar_n,imagheader,'DETECTOR','NIR'
        fxaddpar_n,specheader,'DETECTOR','NIR'
        fxaddpar_n,imagheader,'FILTER','N3'
        if !IRC_SPECRED_PROCESSTARGET.grism EQ 0 then begin
           fxaddpar_n,specheader,'FILTER','NP'
        endif else begin
           fxaddpar_n,specheader,'FILTER','NG'
        endelse
        fxaddpar_n,imagheader,'GAIN',10.7194
        fxaddpar_n,imagheader,'RNOISE',15.3
     end
     
     1: begin
        fxaddpar_n,imagheader,'DETECTOR','MIRS'
        fxaddpar_n,specheader,'DETECTOR','MIRS'
        fxaddpar_n,imagheader,'FILTER','S9W'
        if !IRC_SPECRED_PROCESSTARGET.grism EQ 0 then begin
           fxaddpar_n,specheader,'FILTER','SG1'
        endif else begin
           fxaddpar_n,specheader,'FILTER','SG2'
        endelse
        fxaddpar_n,imagheader,'GAIN',6.43629
        fxaddpar_n,imagheader,'RNOISE',14.2
     end
     
     2: begin
        fxaddpar_n,imagheader,'DETECTOR','MIRL'
        fxaddpar_n,specheader,'DETECTOR','MIRL'
        fxaddpar_n,imagheader,'FILTER','L18W'
        if !IRC_SPECRED_PROCESSTARGET.grism EQ 0 then begin
           fxaddpar_n,specheader,'FILTER','LG1'
        endif else begin
           fxaddpar_n,specheader,'FILTER','LG2'
        endelse
        fxaddpar_n,imagheader,'GAIN',6.43629
        fxaddpar_n,imagheader,'RNOISE',14.2
     end
  endcase
  
; for whole image products
  fxaddpar_n,specheader,'X_SPOFT ',!IRC_SPECRED_SPECEXTRACTPARAM.x_offset,'X offset for spec. extraction box (pix)'
  fxaddpar_n,specheader,'Y_SPOFT ',!IRC_SPECRED_SPECEXTRACTPARAM.y_offset,'Y offset for spec. extraction box (pix)'
  fxaddpar_n,specheader,'X_ZLOFT ',!IRC_SPECRED_SPECEXTRACTPARAM.x_zero_offset,'X offset for zero-th order light (pix)'
  fxaddpar_n,specheader,'Y_ZLOFT ',!IRC_SPECRED_SPECEXTRACTPARAM.y_zero_offset,'Y offset for zero-th order light (pix)'
  fxaddpar_n,specheader,'W_OFFSET',!IRC_SPECRED_SPECPARAM.wave_offset_pix,'WAVE_OFFSET_PIX (pix)'
 
; for extracted image products 
  if !IRC_SPECRED_PROCESSOPTION.AUTO_IMAGE_STACK EQ 0B then begin
     s=size(specheader) & n_specitem=s[1]
     n_source=n_elements(source_table)
     specheader_extract=strarr(n_specitem,n_source)
     for source_id=0,n_source-1 do specheader_extract[*,source_id]=specheader[*,0]
     
     fxaddpar_n,specheader_extract,'SOURCE_X',source_table.image_x,'Source Position X on Reference Image (pix)'
     fxaddpar_n,specheader_extract,'SOURCE_Y',source_table.image_y,'Source Position Y on Reference Image (pix)'
     fxaddpar_n,specheader_extract,'SPEC_X  ',source_table.spec_x,'Source Position X on Spectroscopy Image (pix)'
     fxaddpar_n,specheader_extract,'SPEC_Y  ',source_table.spec_y,'Source Position Y on Spectroscopy Image (pix)'
     fxaddpar_n,specheader_extract,'FLUX_ADU',source_table.flux,'rough APPHOT Flux (ADU)'
     fxaddpar_n,specheader_extract,'FLUX    ',source_table.flux*!IRC_SPECRED_CHIPINFO.fluxconv_fac,'rough APPHOT Flux (mJy)'
     fxaddpar_n,specheader_extract,'S_SIZE_I',source_table.flux,'Gaussian Source Size on Ref. Image in FWHM (pix)'
     fxaddpar_n,specheader_extract,'S_SIZE_S',source_table.spec_bgnoise_ADU,'Gaussian Source Size on Spec. Image in FWHM (pix)'
     fxaddpar_n,specheader_extract,'BADPOSFL',source_table.bad_sourcepos_flag,'Flag for Bad Source Pos. Mes. on Ref. Imag (1=bad) '
     fxaddpar_n,specheader_extract,'NOISE   ',source_table.spec_bgnoise_ADU,'Measured Background Nosise per Pix (ADU)'


     
     s=size(imagheader) & n_imagitem=s[1]
     imagheader_extract=strarr(n_imagitem,n_source)
     for source_id=0,n_source-1 do imagheader_extract[*,source_id]=imagheader[*,0]
     
     fxaddpar_n,imagheader_extract,'SOURCE_X',source_table.image_x,'Source Position X on Reference Image (pix)'
     fxaddpar_n,imagheader_extract,'SOURCE_Y',source_table.image_y,'Source Position Y on Reference Image (pix)'
     fxaddpar_n,imagheader_extract,'FLUX_ADU',source_table.flux,'rough APPHOT Flux (ADU)'
     fxaddpar_n,imagheader_extract,'FLUX    ',source_table.flux*!IRC_SPECRED_CHIPINFO.fluxconv_fac,'rough APPHOT Flux (mJy)'
     fxaddpar_n,imagheader_extract,'S_SIZE_I',source_table.flux,'Gaussian Source Size on Ref. Image in FWHM (pix)'
     fxaddpar_n,imagheader_extract,'BADPOSFL',source_table.bad_sourcepos_flag,'Flag for Bad Source Pos. Mes. on Ref. Imag (1=bad) '
     fxaddpar_n,imagheader_extract,'NPDISTY ',source_table.np_distortion_offset_y,'Y Offset Applied to Correct NP Distortion (meaningful only for NP)'

  endif
  
end
