PRO read_ishihara_cohen,filename,n_star,star_name_good,lambda_good,beta_good,n_pointing,scan_flag,obs_start,obs_end,comment_good

;read_objlist,filename,n_star,star_name,lambda_star,beta_star,n_pointing,scan_flag,obs_start,obs_end,comment

; file format

;#
;# 422 Cohen standard stars (Cohen et al. 1999)
;#   from canadia.ir.isas.jaxa.jp
;#
;#   1 ... Priority
;#   2 ... Simple star or not
;#   3 ... Flux level
;#   4 ... HD name
;#   5 ... IRAS 12um flux(Jy)
;#   6 ... R.A.
;#   7 ... Dec.
;#   8 ... SIMBAD definition
;#
;# 2 3      4        5        6              7              8
;3 X Good   HD28     6.084    00 05 20.1409  -05 42 27.426  Variable of RS CVntype

;common dir_structure,datadir,calibdir

if ~ keyword_set(filename) then begin
    filename=DIALOG_PICKFILE(PATH=!IRC_SPECRED_DIR.calibdir+'StdSpecData/',filter='*.dat')
    IF (STRLEN(filename) EQ 0) THEN stop
endif

X=FLTARR(6000) & Y=FLTARR(6000)
dummy=''
priority=intarr(500)
star_type=strarr(500)
flux_flag=strarr(500)
star_name=strarr(500)
flux_12=fltarr(500)
ra_1=intarr(500)
ra_2=intarr(500)
ra_3=fltarr(500)
dec_1=intarr(500)
dec_2=intarr(500)
dec_3=fltarr(500)
comment=strarr(500)

GET_LUN,U & openr,U,filename

READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header
READF, U, dummy; dummy read for header

i=0
buf=''

WHILE NOT EOF(U) DO BEGIN
    READF, U, buf
    s=strsplit(buf,' ',/extract)
    if s[0] EQ ' ' then break
    priority[i]=fix(s[0])
    star_type[i]=s[1]
    flux_flag[i]=s[2]
    star_name[i]=s[3]
    flux_12[i]=float(s[4])
    ra_1[i]=fix(s[5])
    ra_2[i]=fix(s[6])
    ra_3[i]=float(s[7])
    dec_1[i]=fix(s[8])
    dec_2[i]=fix(s[9])
    dec_3[i]=float(s[10])
    comment[i]=strjoin(s[11:n_elements(s)-1],' ')
    i=i+1
ENDWHILE

close,U & FREE_LUN,U

priority=priority[0:i-1]
star_type=star_type[0:i-1]
star_name=star_name[0:i-1]
flux_12=flux_12[0:i-1]
ra_1=ra_1[0:i-1]
ra_2=ra_2[0:i-1]
ra_3=ra_3[0:i-1]
dec_1=dec_1[0:i-1]
dec_2=dec_2[0:i-1]
dec_3=dec_3[0:i-1]
comment=comment[0:i-1]

count=i

lambda_good=fltarr(i)
beta_good=fltarr(i)
comment_good=strarr(i)
star_name_good=strarr(i)

j=0
for k=0,i-1 do begin
    if priority[k] EQ 1 and star_type[k] EQ 'O' and flux_flag[k] EQ 'Good' then begin
        ra=(float(ra_1[k])+float(ra_2[k])/60.+float(ra_3[k])/3600.)*15.
        dec=ten([dec_1[k],dec_2[k],dec_3[k]])
        euler,ra,dec,lambda_tmp,beta_tmp,3
        lambda_good[j]=lambda_tmp
        beta_good[j]=beta_tmp
        comment_good[j]=string(priority[k])+' '+star_type[k]+' '+flux_flag[k]+' '+string(flux_12[k])+' '+comment[k]
        star_name_good[j]=star_name[k]
        j=j+1
    endif
endfor

lambda_good=lambda_good[0:j-1]
beta_good=beta_good[0:j-1]
comment_good=comment_good[0:j-1]
star_name_good=star_name_good[0:j-1]

n_star=j
obs_start=intarr(j)
obs_end=intarr(j)
scan_flag=intarr(j) & scan_flag[*]=1 ; dummy
n_pointing=intarr(j) & n_pointing[*]=0 ; dummy

END


